/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.item.decay;

import com.petrolpark.PetrolparkDataComponents;
import com.petrolpark.core.item.decay.ItemDecay;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.IItemDecorator;
import net.neoforged.neoforge.client.event.RegisterItemDecorationsEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="petrolpark", bus=EventBusSubscriber.Bus.MOD)
public class DecayingItemDecorator
implements IItemDecorator {
    public boolean render(@Nonnull GuiGraphics guiGraphics, @Nonnull Font font, @Nonnull ItemStack stack, int xOffset, int yOffset) {
        if (!Screen.hasShiftDown()) {
            return false;
        }
        if (!stack.has(PetrolparkDataComponents.DECAY_TIME)) {
            return false;
        }
        Long creationTime = (Long)stack.get(PetrolparkDataComponents.DECAY_START_TIME);
        if (creationTime == null) {
            return false;
        }
        float proportion = 1.0f + (float)(creationTime - ItemDecay.getGameTime()) / (float)ItemDecay.getLifetimeOrNone(stack);
        proportion = Mth.clamp((float)proportion, (float)0.0f, (float)1.0f);
        int color = Mth.hsvToRgb((float)(proportion / 3.0f), (float)(0.5f + proportion * 0.5f), (float)(0.25f + proportion * 0.75f));
        guiGraphics.fill(RenderType.guiOverlay(), xOffset + 2, yOffset + 3, xOffset + 14, yOffset + 5, -16777216);
        guiGraphics.fill(RenderType.guiOverlay(), xOffset + 2, yOffset + 3, xOffset + 2 + (int)(proportion * 12.0f), yOffset + 4, color | 0xFF000000);
        return false;
    }

    @SubscribeEvent
    public static final void onRegisterItemDecorations(RegisterItemDecorationsEvent event) {
        DecayingItemDecorator decorator = new DecayingItemDecorator();
        BuiltInRegistries.ITEM.forEach(item -> event.register((ItemLike)item, (IItemDecorator)decorator));
    }
}

