/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.compression;

import com.petrolpark.core.recipe.compression.IItemCompression;
import com.petrolpark.util.BigItemStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.math.Fraction;

public interface IItemCompressionSequence {
    public static final IItemCompressionSequence EMPTY = new EmptyItemCompressionSequence();

    public ItemStack getBaseItem();

    public List<ItemStack> getAllItems();

    default public int size() {
        return this.getAllItems().size();
    }

    public List<IItemCompression> getAllCompressions();

    public Fraction getEquivalentBaseItems(ItemStack var1);

    public double getEquivalentBaseItems(ItemStack var1, double var2);

    default public Fraction getEquivalentBaseItems(int item) {
        if (item < 0 || item >= this.size()) {
            return null;
        }
        return this.getEquivalentBaseItems(this.getAllItems().get(item));
    }

    public Optional<CompressedBlock> getBaseBlock();

    default public boolean isEmpty() {
        return false;
    }

    default public List<BigItemStack> getFewestStacks(long baseItemCount) {
        if (baseItemCount <= 0L) {
            return Collections.emptyList();
        }
        ArrayList<BigItemStack> stacks = new ArrayList<BigItemStack>(this.size());
        for (int item = this.size() - 1; item >= 0; --item) {
            long amount = Fraction.getFraction((int)((int)baseItemCount), (int)1).divideBy(this.getEquivalentBaseItems(item)).longValue();
            if (amount == 0L) continue;
            stacks.add(new BigItemStack(this.getAllItems().get(item), amount));
            baseItemCount -= Fraction.getFraction((int)((int)amount), (int)1).multiplyBy(this.getEquivalentBaseItems(item)).longValue();
        }
        return stacks;
    }

    public static class EmptyItemCompressionSequence
    implements IItemCompressionSequence {
        protected EmptyItemCompressionSequence() {
        }

        @Override
        public ItemStack getBaseItem() {
            return ItemStack.EMPTY;
        }

        @Override
        public List<ItemStack> getAllItems() {
            return Collections.singletonList(ItemStack.EMPTY);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public List<IItemCompression> getAllCompressions() {
            return Collections.emptyList();
        }

        @Override
        public Fraction getEquivalentBaseItems(ItemStack stack) {
            return null;
        }

        @Override
        public double getEquivalentBaseItems(ItemStack stack, double count) {
            return 0.0;
        }

        @Override
        public Fraction getEquivalentBaseItems(int item) {
            return item == 0 ? Fraction.ZERO : null;
        }

        @Override
        public Optional<CompressedBlock> getBaseBlock() {
            return Optional.empty();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    public record CompressedBlock(Block block, ItemStack stack) {
    }
}

