/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.compression;

import com.mojang.serialization.Codec;
import com.petrolpark.core.recipe.compression.CompressionItemHandler;
import com.petrolpark.core.recipe.compression.IItemCompressionSequence;
import com.petrolpark.core.recipe.compression.ItemCompressionManager;
import com.petrolpark.core.recipe.compression.NoItemCompressionSequence;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.DataComponentUtil;

public class MutableCompressionItemHandler
extends CompressionItemHandler {
    public MutableCompressionItemHandler(int capacity) {
        super(IItemCompressionSequence.EMPTY, capacity);
    }

    @Override
    public ItemStack insertItem(@Nonnull ItemStack stack, boolean simulate) {
        return this.createNewSequenceAndStore(stack, simulate).orElseGet(() -> super.insertItem(stack, simulate));
    }

    @Override
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.createNewSequenceAndStore(stack, simulate).orElseGet(() -> super.insertItem(slot, stack, simulate));
    }

    protected Optional<ItemStack> createNewSequenceAndStore(ItemStack stack, boolean simulate) {
        if (this.sequence.isEmpty()) {
            Optional newSequence = ItemCompressionManager.getSequence(stack).map(this.onNewSequence(simulate));
            if (newSequence.isPresent()) {
                this.sequence = (IItemCompressionSequence)newSequence.get();
                ItemStack remainder = super.insertItem(stack, simulate);
                if (simulate) {
                    this.sequence = IItemCompressionSequence.EMPTY;
                }
                return Optional.of(remainder);
            }
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    protected UnaryOperator<IItemCompressionSequence> onNewSequence(boolean simulate) {
        return sequence -> sequence;
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack extracted = super.extractItem(slot, amount, simulate);
        if (!simulate && this.count == 0) {
            this.sequence = IItemCompressionSequence.EMPTY;
        }
        return extracted;
    }

    @Override
    public CompoundTag serializeNBT(@Nonnull HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        if (!this.sequence.isEmpty()) {
            tag.put("Item", DataComponentUtil.wrapEncodingExceptions((DataComponentHolder)this.sequence.getBaseItem(), (Codec)ItemStack.SINGLE_ITEM_CODEC, (HolderLookup.Provider)provider));
        }
        return tag;
    }

    @Override
    public void deserializeNBT(@Nonnull HolderLookup.Provider provider, @Nonnull CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        Optional stack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)nbt.getCompound("Item"));
        this.sequence = stack.flatMap(ItemCompressionManager::getSequence).map(this.onNewSequence(false)).orElse(stack.map(NoItemCompressionSequence::new).orElse(IItemCompressionSequence.EMPTY));
    }
}

