/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.advanced;

import com.mojang.serialization.MapCodec;
import com.petrolpark.core.contamination.Contaminant;
import com.petrolpark.core.contamination.IContamination;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredient;
import com.petrolpark.core.recipe.ingredient.advanced.IAdvancedIngredientType;
import com.petrolpark.core.recipe.ingredient.advanced.IForcingItemAdvancedIngredient;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.neoforged.neoforge.common.MutableDataComponentHolder;

public record ContaminatedAdvancedIngredient(Holder<Contaminant> contaminant) implements IAdvancedIngredient<MutableDataComponentHolder>,
IForcingItemAdvancedIngredient
{
    public static final MapCodec<ContaminatedAdvancedIngredient> CODEC = CodecHelper.singleFieldMap(Contaminant.CODEC, "contaminant", ContaminatedAdvancedIngredient::contaminant, ContaminatedAdvancedIngredient::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, ContaminatedAdvancedIngredient> STREAM_CODEC = StreamCodec.composite(Contaminant.STREAM_CODEC, ContaminatedAdvancedIngredient::contaminant, ContaminatedAdvancedIngredient::new);
    public static final IAdvancedIngredientType<MutableDataComponentHolder> TYPE = new Type();

    @Override
    public boolean test(MutableDataComponentHolder stack) {
        return IContamination.get(stack).map(contamination -> contamination.has(this.contaminant)).orElse(false);
    }

    @Override
    public Stream<MutableDataComponentHolder> modifyExamples(Stream<MutableDataComponentHolder> exampleStacks) {
        return exampleStacks.map(stack -> {
            IContamination.get(stack).ifPresent(c -> c.contaminate(this.contaminant));
            return stack;
        });
    }

    @Override
    public Stream<MutableDataComponentHolder> modifyCounterExamples(Stream<MutableDataComponentHolder> counterExampleStacks) {
        return counterExampleStacks.map(stack -> {
            IContamination.get(stack).ifPresent(c -> c.decontaminateOnly(this.contaminant));
            return stack;
        });
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder description) {
        description.add(Contaminant.getNameColored(this.contaminant));
    }

    @Override
    public void addToCounterDescription(Lang.IndentedTooltipBuilder description) {
        description.add(Contaminant.getAbsentNameColored(this.contaminant));
    }

    @Override
    @Nonnull
    public Optional<ItemStack> forceLootItemFunction(LootItemFunction function, LootContext context, ItemStack stack) {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<ItemStack> forbidLootItemFunction(LootItemFunction function, LootContext context, ItemStack stack) {
        return Optional.empty();
    }

    @Override
    @Nullable
    public Optional<MerchantOffer> forceTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        return null;
    }

    @Override
    @Nullable
    public Optional<MerchantOffer> forbidTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        return null;
    }

    @Override
    public IAdvancedIngredientType<MutableDataComponentHolder> getType() {
        return TYPE;
    }

    public static final class Type
    implements IAdvancedIngredientType<MutableDataComponentHolder> {
        @Override
        public MapCodec<ContaminatedAdvancedIngredient> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ContaminatedAdvancedIngredient> streamCodec() {
            return STREAM_CODEC;
        }

        @Override
        public Stream<ContaminatedAdvancedIngredient> streamApplicableIngredients(Level level, MutableDataComponentHolder stack) {
            return IContamination.get(stack).stream().flatMap(IContamination::streamAllContaminants).map(ContaminatedAdvancedIngredient::new);
        }
    }
}

