/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.ingredient.advanced;

import com.mojang.serialization.MapCodec;
import com.petrolpark.PetrolparkAdvancedIngredientTypes;
import com.petrolpark.core.data.loot.numberprovider.NumberEstimate;
import com.petrolpark.core.recipe.ingredient.advanced.INamedAdvancedIngredientType;
import com.petrolpark.core.recipe.ingredient.advanced.ItemAdvancedIngredient;
import com.petrolpark.util.CodecHelper;
import com.petrolpark.util.Lang;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.neoforged.neoforge.common.CommonHooks;

public record EnchantmentItemAdvancedIngredient(EnchantmentPredicate enchantments) implements ItemAdvancedIngredient
{
    public static final MapCodec<EnchantmentItemAdvancedIngredient> CODEC = CodecHelper.singleFieldMap(EnchantmentPredicate.CODEC, "enchantments", EnchantmentItemAdvancedIngredient::enchantments, EnchantmentItemAdvancedIngredient::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, EnchantmentItemAdvancedIngredient> STREAM_CODEC = StreamCodec.composite(CodecHelper.ENCHANTMENT_PREDICATE_STREAM_CODEC, EnchantmentItemAdvancedIngredient::enchantments, EnchantmentItemAdvancedIngredient::new);
    public static final RandomSource RANDOM = new XoroshiroRandomSource(123456789L);

    @Override
    public boolean test(ItemStack stack) {
        return this.enchantments().containedIn(EnchantmentItemAdvancedIngredient.getEnchantments(stack));
    }

    @Override
    @Nullable
    public Stream<ItemStack> modifyExamples(Stream<ItemStack> exampleStacks) {
        return this.enchantments().enchantments().map(enchantments -> exampleStacks.flatMap(stack -> enchantments.stream().map(enchantment -> {
            if (this.enchantments().level().matches(stack.getEnchantmentLevel(enchantment))) {
                return null;
            }
            ItemStack copy = stack.copy();
            copy.enchant(enchantment, this.enchantments().level().min().orElse(1).intValue());
            return copy;
        }))).orElse(exampleStacks);
    }

    @Override
    @Nullable
    public Stream<ItemStack> modifyCounterExamples(Stream<ItemStack> counterExampleStacks) {
        return counterExampleStacks.map(stack -> {
            ItemEnchantments.Mutable mutableItemEnchantments = new ItemEnchantments.Mutable(EnchantmentItemAdvancedIngredient.getEnchantments(stack));
            this.enchantments().enchantments().ifPresentOrElse(enchantments -> enchantments.forEach(enchantment -> mutableItemEnchantments.set(enchantment, this.enchantments().level().min().orElse(0).intValue())), () -> mutableItemEnchantments.keySet().forEach(enchantment -> mutableItemEnchantments.set(enchantment, this.enchantments().level().min().orElse(0).intValue())));
            stack.set(DataComponents.ENCHANTMENTS, (Object)mutableItemEnchantments.toImmutable());
            return stack;
        });
    }

    @Override
    @Nonnull
    public Optional<ItemStack> forceLootItemFunction(LootItemFunction function, LootContext context, ItemStack stack) {
        Function<Holder, Float> maxLevel;
        Stream<Holder<Enchantment>> possibleEnchantments;
        if (function instanceof EnchantRandomlyFunction) {
            EnchantRandomlyFunction enchantRandomlyFunction = (EnchantRandomlyFunction)function;
            possibleEnchantments = enchantRandomlyFunction.options.map(HolderSet::stream).orElseGet(EnchantmentItemAdvancedIngredient.allEnchantments(context)).filter(enchantment -> !enchantRandomlyFunction.onlyCompatible || stack.is(Items.BOOK) || stack.supportsEnchantment(enchantment));
            maxLevel = enchantment -> Float.valueOf(((Enchantment)enchantment.value()).getMaxLevel());
        } else if (function instanceof EnchantWithLevelsFunction) {
            EnchantWithLevelsFunction enchantWithLevelsFunction = (EnchantWithLevelsFunction)function;
            possibleEnchantments = enchantWithLevelsFunction.options.map(HolderSet::stream).orElseGet(EnchantmentItemAdvancedIngredient.allEnchantments(context));
            maxLevel = enchantment -> Float.valueOf(NumberEstimate.getMax(context, enchantWithLevelsFunction.levels));
        } else {
            return Optional.empty();
        }
        for (Holder enchantment2 : possibleEnchantments.filter(e -> this.enchantments().enchantments().map(enchantments -> enchantments.contains(e)).orElse(true)).toList()) {
            int minLevel = this.enchantments().level().min().orElse(1);
            if (!((float)minLevel <= maxLevel.apply(enchantment2).floatValue())) continue;
            stack.enchant(enchantment2, minLevel);
            return Optional.of(stack);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<ItemStack> forbidLootItemFunction(LootItemFunction function, LootContext context, ItemStack stack) {
        return ItemAdvancedIngredient.super.forbidLootItemFunction(function, context, stack);
    }

    @Override
    @Nullable
    public Optional<MerchantOffer> forceTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        return ItemAdvancedIngredient.super.forceTradeListing(tradeListing, trader, random);
    }

    @Override
    @Nullable
    public Optional<MerchantOffer> forbidTradeListing(VillagerTrades.ItemListing tradeListing, Entity trader, RandomSource random) {
        return ItemAdvancedIngredient.super.forbidTradeListing(tradeListing, trader, random);
    }

    @Override
    public void addToDescription(Lang.IndentedTooltipBuilder description) {
        this.addToDescriptionInternal(description, "");
    }

    @Override
    public void addToCounterDescription(Lang.IndentedTooltipBuilder description) {
        this.addToDescriptionInternal(description, ".inverse");
    }

    protected void addToDescriptionInternal(Lang.IndentedTooltipBuilder description, String postfix) {
        boolean ranged = !this.enchantments().level().isAny();
        Component range = Lang.range(this.enchantments().level().min().map(i -> Float.valueOf(i.intValue())).orElse(Float.valueOf(Float.NaN)).floatValue(), this.enchantments().level().min().map(i -> Float.valueOf(i.intValue())).orElse(Float.valueOf(Float.NaN)).floatValue(), Lang.INT_DF);
        if (this.enchantments().enchantments().isPresent()) {
            HolderSet enchantments = (HolderSet)this.enchantments().enchantments().get();
            if (enchantments.size() == 1) {
                Component name = ((Enchantment)enchantments.get(0).value()).description();
                if (ranged) {
                    description.add(this.translate("single.level_range" + postfix, name, range));
                } else {
                    description.add(this.translate("single" + postfix, name));
                }
            } else {
                if (ranged) {
                    description.add(this.translate("any.level_range" + postfix, range));
                } else {
                    description.add(this.translate("any" + postfix, new Object[0]));
                }
                description.indent();
                enchantments.stream().map(Holder::value).map(Enchantment::description).forEach(description::add);
                description.unindent();
            }
        } else if (ranged) {
            description.add(this.translate("level_range" + postfix, range));
        } else {
            description.add(this.translate(postfix, new Object[0]));
        }
    }

    @Override
    public INamedAdvancedIngredientType<ItemStack> getType() {
        return (INamedAdvancedIngredientType)PetrolparkAdvancedIngredientTypes.ITEM_ENCHANTMENTS.get();
    }

    protected static final Supplier<Stream<Holder<Enchantment>>> allEnchantments(LootContext context) {
        return () -> context.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT).holders().map(Function.identity());
    }

    protected static final ItemEnchantments getEnchantments(ItemStack stack) {
        return stack.getAllEnchantments(CommonHooks.resolveLookup((ResourceKey)Registries.ENCHANTMENT));
    }

    public record Type(String translationKey) implements INamedAdvancedIngredientType<ItemStack>
    {
        @Override
        public MapCodec<EnchantmentItemAdvancedIngredient> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, EnchantmentItemAdvancedIngredient> streamCodec() {
            return STREAM_CODEC;
        }

        @Override
        public Stream<EnchantmentItemAdvancedIngredient> streamApplicableIngredients(Level level, ItemStack stack) {
            if (stack.isEnchanted()) {
                return Stream.concat(stack.getAllEnchantments(level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT)).entrySet().stream().flatMap(entry -> Stream.of(new EnchantmentItemAdvancedIngredient(new EnchantmentPredicate((Holder)entry.getKey(), MinMaxBounds.Ints.ANY)), new EnchantmentItemAdvancedIngredient(new EnchantmentPredicate((Holder)entry.getKey(), MinMaxBounds.Ints.atLeast((int)entry.getIntValue()))))), Stream.of(new EnchantmentItemAdvancedIngredient(new EnchantmentPredicate(Optional.empty(), MinMaxBounds.Ints.ANY))));
            }
            return Stream.empty();
        }
    }
}

