/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.recipe.recycling;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.util.BigItemStack;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;

public final class RecyclingOutput {
    public static final Codec<RecyclingOutput> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("item").forGetter(RecyclingOutput::getItem), (App)Codec.DOUBLE.fieldOf("expectedCount").forGetter(RecyclingOutput::getExpectedCount)).apply((Applicative)instance, RecyclingOutput::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RecyclingOutput> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, RecyclingOutput::getItem, (StreamCodec)ByteBufCodecs.DOUBLE, RecyclingOutput::getExpectedCount, RecyclingOutput::new);
    protected ItemStack item;
    protected double expectedCount;

    public RecyclingOutput(ItemStack stack) {
        this(stack, stack.getCount());
    }

    public RecyclingOutput(ItemStack stack, double expectedCount) {
        this.item = stack.copyWithCount(1);
        this.expectedCount = expectedCount;
    }

    public RecyclingOutput(BigItemStack bigStack) {
        this(bigStack.getSingleItemStack(), bigStack.getCount());
    }

    protected ItemStack getItem() {
        return this.item;
    }

    protected double getExpectedCount() {
        return this.expectedCount;
    }

    public double getExpectedRemainder() {
        return this.expectedCount - (double)((long)this.expectedCount);
    }

    public RecyclingOutput multiply(double multiplier) {
        this.expectedCount *= multiplier;
        return this;
    }

    public RecyclingOutput copy() {
        return new RecyclingOutput(this.item.copy(), this.expectedCount);
    }

    public BigItemStack rollStack(double multiplier, RandomSource random) {
        int amount = (int)(this.expectedCount * multiplier);
        return new BigItemStack(this.item, (double)((float)amount + random.nextFloat()) > this.expectedCount * multiplier - (double)amount ? 1L : 0L);
    }

    public int compareTo(RecyclingOutput recyclingOutput) {
        return recyclingOutput.item.hashCode() - this.item.hashCode();
    }
}

