/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.core.trade;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.petrolpark.core.trade.ITradeListingReference;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;

public interface IVillagerTradeListingReference
extends ITradeListingReference {
    public static <REF extends IVillagerTradeListingReference> MapCodec<REF> codec(Factory<REF> factory) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.VILLAGER_PROFESSION.byNameCodec().fieldOf("profession").forGetter(IVillagerTradeListingReference::profession), (App)Codec.intRange((int)1, (int)5).fieldOf("level").forGetter(IVillagerTradeListingReference::level), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("index").forGetter(IVillagerTradeListingReference::index)).apply((Applicative)instance, factory::create));
    }

    public static <REF extends IVillagerTradeListingReference> StreamCodec<RegistryFriendlyByteBuf, REF> streamCodec(Factory<REF> factory) {
        return StreamCodec.composite((StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.VILLAGER_PROFESSION), IVillagerTradeListingReference::profession, (StreamCodec)ByteBufCodecs.INT, IVillagerTradeListingReference::level, (StreamCodec)ByteBufCodecs.INT, IVillagerTradeListingReference::index, factory::create);
    }

    @Override
    default public VillagerTrades.ItemListing get() {
        Int2ObjectMap<VillagerTrades.ItemListing[]> professionListings = this.getAllListings().get(this.profession());
        if (professionListings == null) {
            return ITradeListingReference.FAILURE;
        }
        VillagerTrades.ItemListing[] listings = (VillagerTrades.ItemListing[])professionListings.get(this.level());
        if (this.index() < listings.length) {
            return listings[this.index()];
        }
        return FAILURE;
    }

    public Map<VillagerProfession, Int2ObjectMap<VillagerTrades.ItemListing[]>> getAllListings();

    public VillagerProfession profession();

    public int level();

    public int index();

    @FunctionalInterface
    public static interface Factory<REF extends ITradeListingReference> {
        public REF create(VillagerProfession var1, int var2, int var3);
    }
}

