/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin;

import com.petrolpark.core.extendedinventory.ExtendedInventory;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={AbstractContainerMenu.class})
public abstract class AbstractContainerMenuMixin
implements ExtendedInventory.DelayedSlotPopulation {
    @Shadow
    private ItemStack carried;
    @Shadow
    private int stateId;
    @Shadow
    public NonNullList<Slot> slots;
    @Unique
    private Int2ObjectMap<ItemStack> delayedSlotStacks = new Int2ObjectArrayMap();

    @Shadow
    public abstract Slot getSlot(int var1);

    @Shadow
    public abstract boolean isValidSlotIndex(int var1);

    @Override
    public void populateDelayedSlots() {
        this.delayedSlotStacks.forEach((i, s) -> this.getSlot((int)i).set(s));
    }

    @Overwrite
    public void setItem(int pSlotId, int pStateId, ItemStack pStack) {
        if (!this.isValidSlotIndex(pSlotId)) {
            this.delayedSlotStacks.put(pSlotId, (Object)pStack);
        } else {
            this.getSlot(pSlotId).set(pStack);
        }
        this.stateId = pStateId;
    }

    @Overwrite
    public void initializeContents(int pStateId, List<ItemStack> pItems, ItemStack pCarried) {
        for (int i = 0; i < pItems.size(); ++i) {
            ItemStack stack = pItems.get(i);
            if (!this.isValidSlotIndex(i)) {
                this.delayedSlotStacks.put(i, (Object)stack);
                continue;
            }
            this.getSlot(i).set(stack);
        }
        this.carried = pCarried;
        this.stateId = pStateId;
    }
}

