/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.petrolpark.PetrolparkRecipeTypes;
import com.petrolpark.core.recipe.book.IBookRequiredRecipe;
import com.petrolpark.core.recipe.book.IRecipeBookAcceptorBlock;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.CrafterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={CrafterBlock.class})
public abstract class CrafterBlockMixin
extends BaseEntityBlock
implements IRecipeBookAcceptorBlock {
    protected CrafterBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
        throw new AssertionError();
    }

    @ModifyExpressionValue(method={"dispenseFrom"}, at={@At(value="INVOKE", target="getPotentialResults")})
    public Optional<RecipeHolder<CraftingRecipe>> modifyGetPotentialResults(Optional<RecipeHolder<CraftingRecipe>> original, BlockState state, ServerLevel level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof CrafterBlockEntity)) {
            return original;
        }
        CrafterBlockEntity crafter = (CrafterBlockEntity)blockEntity;
        return original.or(() -> level.getRecipeManager().getRecipeFor((RecipeType)PetrolparkRecipeTypes.CRAFTING_BOOK_REQUIRED.get(), (RecipeInput)crafter.asCraftInput(), (Level)level).filter(rh -> IBookRequiredRecipe.hasRequiredBook((Level)level, pos, rh)).map(rh -> new RecipeHolder(rh.id(), (Recipe)((CraftingRecipe)rh.value()))));
    }

    @Override
    public boolean acceptsRecipeBook(Level level, BlockPos pos, BlockState state, RecipeHolder<?> recipeHolder) {
        return recipeHolder.value().getType() == PetrolparkRecipeTypes.CRAFTING_BOOK_REQUIRED.get();
    }
}

