/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class BigItemStack {
    public static final BigItemStack EMPTY = new BigItemStack(ItemStack.EMPTY);
    protected final ItemStack stack;
    protected final long count;

    public BigItemStack(ItemStack stack) {
        this(stack, (long)stack.getCount());
    }

    public BigItemStack(ItemStack stack, long count) {
        this.stack = stack.copyWithCount(1);
        this.count = count;
    }

    public BigItemStack(ItemLike item, long count) {
        this.stack = new ItemStack(item);
        this.count = count;
    }

    public ItemStack getSingleItemStack() {
        return this.stack.copy();
    }

    public long getCount() {
        return this.count;
    }

    public List<ItemStack> getAsStacks() {
        long leftOver = this.count % (long)this.stack.getMaxStackSize();
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.count / (long)this.stack.getMaxStackSize() + leftOver == 0L ? 0 : 1);
        for (long i = 0L; i < this.count / (long)this.stack.getMaxStackSize(); ++i) {
            stacks.add(this.stack.copyWithCount(this.stack.getMaxStackSize()));
        }
        if (leftOver > 0L) {
            stacks.add(this.stack.copyWithCount((int)leftOver));
        }
        return stacks;
    }

    public ItemStack copyStackWithCount(int count) {
        return this.stack.copyWithCount(count);
    }

    public BigItemStack copyWithCount(long count) {
        return new BigItemStack(this.stack, count);
    }
}

