/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.durabilityrarity.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.samxel.durabilityrarity.RarityUtil;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Item.class}, priority=2000)
public class ItemBarMixin {
    @ModifyReturnValue(method={"getBarWidth"}, at={@At(value="RETURN")})
    private int modifyBarWidth(int original, ItemStack stack) {
        Integer max = RarityUtil.getRarityMaxDurability(stack).orElse(null);
        if (max != null && max > 0) {
            int damage = stack.getDamageValue();
            return Math.round(13.0f - (float)damage * 13.0f / (float)max.intValue());
        }
        return original;
    }

    @ModifyReturnValue(method={"getBarColor"}, at={@At(value="RETURN")})
    private int modifyBarColor(int original, ItemStack stack) {
        Integer max = RarityUtil.getRarityMaxDurability(stack).orElse(null);
        if (max != null && max > 0) {
            int damage = stack.getDamageValue();
            float f = Math.max(0.0f, ((float)max.intValue() - (float)damage) / (float)max.intValue());
            return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
        }
        return original;
    }
}

