/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.durabilityrarity;

import com.samxel.durabilityrarity.RarityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="durabilityrarity", value={Dist.CLIENT})
public class TooltipHandler {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List toolTip = event.getToolTip();
        if (stack.m_41782_() && stack.m_41783_().m_128441_("rarity_class")) {
            String rarityName = stack.m_41783_().m_128461_("rarity_class");
            RarityUtil.RarityClass rarity = RarityUtil.RarityClass.valueOf(rarityName);
            MutableComponent rarityComponent = Component.m_237113_((String)TooltipHandler.getRarityDisplayName(rarity)).m_130940_(TooltipHandler.getRarityColor(rarity));
            toolTip.add(1, rarityComponent);
        }
        ArrayList<Component> plusAttackSpeed = new ArrayList<Component>();
        for (Component line : toolTip) {
            String text = line.getString();
            if (!text.startsWith("+") || !text.contains("Attack Speed")) continue;
            plusAttackSpeed.add(line);
        }
        toolTip.removeAll(plusAttackSpeed);
        block1: for (Component plusLine : plusAttackSpeed) {
            for (int i = 0; i < toolTip.size(); ++i) {
                String baseText = ((Component)toolTip.get(i)).getString();
                if (baseText.startsWith("+") || !baseText.contains("Attack Speed")) continue;
                toolTip.add(i + 1, plusLine);
                continue block1;
            }
        }
    }

    private static String getRarityDisplayName(RarityUtil.RarityClass rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case RarityUtil.RarityClass.BROKEN -> "Broken";
            case RarityUtil.RarityClass.DAMAGED -> "Damaged";
            case RarityUtil.RarityClass.COMMON -> "Common";
            case RarityUtil.RarityClass.RARE -> "Rare";
            case RarityUtil.RarityClass.EPIC -> "Epic";
            case RarityUtil.RarityClass.LEGENDARY -> "Legendary";
        };
    }

    private static ChatFormatting getRarityColor(RarityUtil.RarityClass rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case RarityUtil.RarityClass.BROKEN -> ChatFormatting.DARK_GRAY;
            case RarityUtil.RarityClass.DAMAGED -> ChatFormatting.GRAY;
            case RarityUtil.RarityClass.COMMON -> ChatFormatting.WHITE;
            case RarityUtil.RarityClass.RARE -> ChatFormatting.AQUA;
            case RarityUtil.RarityClass.EPIC -> ChatFormatting.LIGHT_PURPLE;
            case RarityUtil.RarityClass.LEGENDARY -> ChatFormatting.GOLD;
        };
    }
}

