/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.durabilityrarity.mixin;

import com.mojang.logging.LogUtils;
import com.samxel.durabilityrarity.RarityUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SmithingMenu.class})
public abstract class SmithingMenuMixin {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Shadow
    private Level f_40241_;

    @Inject(method={"createResult", "m_6640_"}, at={@At(value="RETURN")}, remap=true)
    private void durabilityrarity$applyRarityAfterCreateResult(CallbackInfo ci) {
        if (this.f_40241_ == null || this.f_40241_.m_5776_()) {
            return;
        }
        SmithingMenu self = (SmithingMenu)this;
        ItemStack result = self.m_38853_(3).m_7993_();
        ItemStack base = self.m_38853_(1).m_7993_();
        LOGGER.warn("[DR|Smithing@1.20.1] createResult(RETURN) | resultEmpty={} baseEmpty={} resultDmgbl={} baseDmgbl={}", new Object[]{result.m_41619_(), base.m_41619_(), result.m_41763_(), base.m_41763_()});
        if (result.m_41619_() || base.m_41619_() || !result.m_41763_() || !base.m_41763_()) {
            return;
        }
        RarityUtil.getRarity(base).ifPresentOrElse(rarity -> {
            CompoundTag tag;
            int baseCurMax = Math.max(base.m_41776_(), 1);
            int baseDmg = Math.max(base.m_41773_(), 0);
            float usedRatio = Math.min(Math.max((float)baseDmg / (float)baseCurMax, 0.0f), 1.0f);
            int vanillaOutMax = new ItemStack((ItemLike)result.m_41720_()).m_41776_();
            if (result.m_41782_() && (tag = result.m_41783_()) != null) {
                tag.m_128473_("rarity_max_durability");
                tag.m_128473_("rarity_class");
            }
            LOGGER.warn("[DR|Smithing][PRE] base='{}' dmg={} curMax={} usedRatio={} | result='{}' curMax={} vanillaOutMax={} | rarity={}", new Object[]{base.m_41611_().getString(), baseDmg, baseCurMax, String.format("%.4f", Float.valueOf(usedRatio)), result.m_41611_().getString(), result.m_41776_(), vanillaOutMax, rarity});
            RarityUtil.applyRarity(result, rarity, null);
            int finalMax = Math.max(result.m_41776_(), 1);
            int finalDmg = Math.min(Math.round(usedRatio * (float)finalMax), Math.max(0, finalMax - 1));
            result.m_41721_(finalDmg);
            LOGGER.warn("[DR|Smithing][POST] rarity={} | finalMax={} finalDmg={} remaining={} usedRatio={}", new Object[]{rarity, finalMax, finalDmg, finalMax - finalDmg, String.format("%.4f", Float.valueOf(usedRatio))});
        }, () -> LOGGER.warn("[DR|Smithing] base has no rarity -> no changes (result='{}')", (Object)result.m_41611_().getString()));
    }
}

