/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.durabilityrarity;

import com.mojang.logging.LogUtils;
import com.samxel.durabilityrarity.Config;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class RarityUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            RarityUtil.ensureRarity(stack, player.m_217043_(), player);
        }
    }

    public static void ensureRarity(ItemStack stack, RandomSource random, Player player) {
        if (!(!stack.m_41763_() || stack.m_41782_() && stack.m_41783_().m_128441_("rarity_class"))) {
            RarityClass rarity = RarityUtil.getRandomRarity(random);
            RarityUtil.applyRarity(stack, rarity, player);
        }
    }

    public static RarityClass getRandomRarity(RandomSource random) {
        int roll = random.m_188503_(100) + 1;
        int cumulative = 0;
        for (RarityClass rarity : RarityClass.values()) {
            if (roll > (cumulative += Config.getChance(rarity))) continue;
            return rarity;
        }
        return RarityClass.COMMON;
    }

    public static void applyRarity(ItemStack stack, RarityClass rarity, Player player) {
        double multiplier = Config.getMultiplier(rarity);
        int baseMaxDurability = stack.m_41776_();
        int newMax = (int)Math.round((double)baseMaxDurability * multiplier);
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("rarity_class", rarity.name());
        tag.m_128405_("rarity_max_durability", newMax);
        int currentDamage = stack.m_41773_();
        int newDamage = Math.min(currentDamage, newMax - 1);
        stack.m_41721_(newDamage);
        LOGGER.debug("Assigned rarity [{}] to item [{}] for player [{}] (new max durability: {}, old max: {}, current damage: {})", new Object[]{rarity.name(), stack.m_41611_().getString(), player != null ? player.m_7755_().getString() : "unknown", newMax, baseMaxDurability, currentDamage});
    }

    public static enum RarityClass {
        BROKEN,
        DAMAGED,
        COMMON,
        RARE,
        EPIC,
        LEGENDARY;

    }
}

