/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.durabilityrarity;

import com.samxel.durabilityrarity.RarityUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="durabilityrarity", value={Dist.CLIENT})
public class TooltipHandler {
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41782_() && stack.m_41783_().m_128441_("rarity_class")) {
            String rarityName = stack.m_41783_().m_128461_("rarity_class");
            RarityUtil.RarityClass rarity = RarityUtil.RarityClass.valueOf(rarityName);
            MutableComponent rarityComponent = Component.m_237113_((String)TooltipHandler.getRarityDisplayName(rarity)).m_130940_(TooltipHandler.getRarityColor(rarity));
            event.getToolTip().add(1, rarityComponent);
        }
    }

    private static String getRarityDisplayName(RarityUtil.RarityClass rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case RarityUtil.RarityClass.BROKEN -> "Broken";
            case RarityUtil.RarityClass.DAMAGED -> "Damaged";
            case RarityUtil.RarityClass.COMMON -> "Common";
            case RarityUtil.RarityClass.RARE -> "Rare";
            case RarityUtil.RarityClass.EPIC -> "Epic";
            case RarityUtil.RarityClass.LEGENDARY -> "Legendary";
        };
    }

    private static ChatFormatting getRarityColor(RarityUtil.RarityClass rarity) {
        return switch (rarity) {
            default -> throw new IncompatibleClassChangeError();
            case RarityUtil.RarityClass.BROKEN -> ChatFormatting.DARK_GRAY;
            case RarityUtil.RarityClass.DAMAGED -> ChatFormatting.GRAY;
            case RarityUtil.RarityClass.COMMON -> ChatFormatting.WHITE;
            case RarityUtil.RarityClass.RARE -> ChatFormatting.AQUA;
            case RarityUtil.RarityClass.EPIC -> ChatFormatting.LIGHT_PURPLE;
            case RarityUtil.RarityClass.LEGENDARY -> ChatFormatting.GOLD;
        };
    }
}

