/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.durabilityrarity;

import com.samxel.durabilityrarity.Config;
import com.samxel.durabilityrarity.RarityUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;

public class AttributeHandler {
    private static final ResourceLocation LEGENDARY_ATTACK_SPEED_ID = ResourceLocation.fromNamespaceAndPath((String)"durabilityrarity", (String)"legendary_attack_speed_bonus");

    @SubscribeEvent
    public static void onItemAttributeModifiers(ItemAttributeModifierEvent event) {
        ItemStack stack = event.getItemStack();
        RarityUtil.RarityClass rarity = RarityUtil.getRarity(stack).orElse(null);
        if (rarity != RarityUtil.RarityClass.LEGENDARY) {
            return;
        }
        double vanillaAttackSpeed = event.getModifiers().stream().filter(e -> e.attribute().equals((Object)Attributes.ATTACK_SPEED)).filter(e -> e.slot() == EquipmentSlotGroup.MAINHAND || e.slot() == EquipmentSlotGroup.HAND || e.slot() == EquipmentSlotGroup.ANY).mapToDouble(e -> e.modifier().amount()).sum();
        double effective = 4.0 + vanillaAttackSpeed;
        double multiplier = Config.getLegendarySpeed();
        double bonus = effective * (multiplier - 1.0);
        event.addModifier(Attributes.ATTACK_SPEED, new AttributeModifier(LEGENDARY_ATTACK_SPEED_ID, bonus, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
    }
}

