/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.main;

import com.dooji.underlay.main.Underlay;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RailBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.TrapDoorBlock;

public class UnderlayApi {
    static final Set<Block> CUSTOM_BLOCKS = ConcurrentHashMap.newKeySet();
    static final Set<Block> CUSTOM_BLOCKS_DP = ConcurrentHashMap.newKeySet();

    public static void registerOverlayBlock(Block block) {
        if (block == null) {
            return;
        }
        CUSTOM_BLOCKS.add(block);
    }

    static void registerDatapackOverlayBlock(Block block) {
        if (block == null) {
            return;
        }
        CUSTOM_BLOCKS_DP.add(block);
    }

    public static boolean isOverlayBlock(Block block) {
        if (block == null) {
            return false;
        }
        if (CUSTOM_BLOCKS.contains(block) || CUSTOM_BLOCKS_DP.contains(block)) {
            return true;
        }
        Optional maybeExcluded = BuiltInRegistries.BLOCK.getTag(Underlay.EXCLUDE_TAG);
        if (maybeExcluded.map(named -> named.stream().anyMatch(holder -> holder.value() == block)).orElse(false).booleanValue()) {
            return false;
        }
        return block instanceof CarpetBlock || block instanceof ButtonBlock || block instanceof TrapDoorBlock || block instanceof PressurePlateBlock || block instanceof SlabBlock || block instanceof RailBlock;
    }
}

