/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay;

import com.dooji.underlay.Underlay;
import com.dooji.underlay.UnderlayApi;
import com.dooji.underlay.UnderlayPersistenceHandler;
import com.dooji.underlay.network.UnderlayNetworking;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1264;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class UnderlayManager {
    private static final Map<String, Map<class_2338, class_2680>> OVERLAYS = new ConcurrentHashMap<String, Map<class_2338, class_2680>>();

    public static void addOverlay(class_3222 player, class_3218 world, class_2338 pos, class_2680 blockState) {
        if (world == null || pos == null || blockState == null) {
            Underlay.LOGGER.warn("Attempted to add overlay with null parameters");
            return;
        }
        if (!UnderlayApi.isOverlayBlock(world, blockState.method_26204())) {
            Underlay.LOGGER.warn("Attempted to add non-overlay block as overlay: " + String.valueOf(blockState));
            return;
        }
        String dimensionKey = UnderlayManager.getDimensionKey((class_1937)world);
        Map worldOverlays = OVERLAYS.computeIfAbsent(dimensionKey, k -> new ConcurrentHashMap());
        if (worldOverlays.containsKey(pos)) {
            class_2680 old = (class_2680)worldOverlays.get(pos);
            if (!player.method_68878()) {
                class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)new class_1799((class_1935)old.method_26204()));
            }
        }
        try {
            worldOverlays.put(pos.method_10062(), blockState);
            UnderlayNetworking.broadcastAdd(world, pos);
            if (!world.method_8608() && world instanceof class_3218) {
                UnderlayPersistenceHandler.saveOverlays((class_1937)world, worldOverlays);
            }
        }
        catch (Exception e) {
            Underlay.LOGGER.error("Failed to add overlay at " + String.valueOf(pos), (Throwable)e);
        }
    }

    public static boolean removeOverlay(class_1937 world, class_2338 pos) {
        if (world == null || pos == null) {
            Underlay.LOGGER.warn("Attempted to remove overlay with null parameters");
            return false;
        }
        String dimensionKey = UnderlayManager.getDimensionKey(world);
        Map<class_2338, class_2680> worldOverlays = OVERLAYS.get(dimensionKey);
        try {
            if (worldOverlays != null && worldOverlays.containsKey(pos)) {
                worldOverlays.remove(pos);
                if (!world.method_8608() && world instanceof class_3218) {
                    UnderlayPersistenceHandler.saveOverlays(world, worldOverlays);
                }
                return true;
            }
        }
        catch (Exception e) {
            Underlay.LOGGER.error("Failed to remove overlay at " + String.valueOf(pos), (Throwable)e);
        }
        return false;
    }

    public static boolean hasOverlay(class_1937 world, class_2338 pos) {
        String dimensionKey = UnderlayManager.getDimensionKey(world);
        Map<class_2338, class_2680> worldOverlays = OVERLAYS.get(dimensionKey);
        return worldOverlays != null && worldOverlays.containsKey(pos);
    }

    public static class_2680 getOverlay(class_1937 world, class_2338 pos) {
        String dimensionKey = UnderlayManager.getDimensionKey(world);
        Map<class_2338, class_2680> worldOverlays = OVERLAYS.get(dimensionKey);
        if (worldOverlays != null && worldOverlays.containsKey(pos)) {
            return worldOverlays.get(pos);
        }
        return class_2246.field_10124.method_9564();
    }

    public static Map<class_2338, class_2680> getOverlaysFor(class_1937 world) {
        String key = world.method_27983().method_29177().toString();
        return OVERLAYS.getOrDefault(key, Map.of());
    }

    public static void loadOverlays(class_1937 world) {
        if (world.method_8608() || !(world instanceof class_3218)) {
            return;
        }
        String dimensionKey = UnderlayManager.getDimensionKey(world);
        Map<class_2338, class_2680> worldOverlays = UnderlayPersistenceHandler.loadOverlays(world);
        OVERLAYS.put(dimensionKey, worldOverlays);
        Underlay.LOGGER.info("Loaded " + worldOverlays.size() + " overlays for dimension " + dimensionKey);
    }

    private static String getDimensionKey(class_1937 world) {
        return world.method_27983().method_29177().toString();
    }
}

