/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay;

import com.dooji.underlay.UnderlayManagerClient;
import com.dooji.underlay.UnderlayRaycast;
import com.dooji.underlay.UnderlayRenderer;
import com.dooji.underlay.mixin.client.ClientPlayerInteractionManagerAccessor;
import com.dooji.underlay.network.payloads.AddOverlayPayload;
import com.dooji.underlay.network.payloads.RemoveOverlayPayload;
import com.dooji.underlay.network.payloads.SyncOverlaysPayload;
import io.netty.buffer.Unpooled;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

@Environment(value=EnvType.CLIENT)
public class UnderlayClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientTickEvents.END_CLIENT_TICK.register(this::onClientTick);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)SyncOverlaysPayload.ID, (client, handler, buf, responseSender) -> {
            SyncOverlaysPayload payload = SyncOverlaysPayload.read(buf);
            client.execute(() -> {
                class_7225.class_7226 lookup = client.method_1562().method_29091().method_46762(class_7924.field_41254);
                Map<class_2338, class_2680> map = payload.tags().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, arg_0 -> UnderlayClient.lambda$onInitializeClient$0((class_7871)lookup, arg_0)));
                UnderlayManagerClient.sync(map);
                UnderlayRenderer.clearAllOverlays();
                UnderlayManagerClient.getAll().forEach(UnderlayRenderer::registerOverlay);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)AddOverlayPayload.ID, (client, handler, buf, responseSender) -> {
            AddOverlayPayload payload = AddOverlayPayload.read(buf);
            client.execute(() -> {
                class_7225.class_7226 lookup = client.method_1562().method_29091().method_46762(class_7924.field_41254);
                class_2338 pos = payload.pos();
                class_2680 state = class_2512.method_10681((class_7871)lookup, (class_2487)payload.stateTag());
                UnderlayManagerClient.syncAdd(pos, state);
                UnderlayRenderer.registerOverlay(pos, state);
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RemoveOverlayPayload.ID, (client, handler, buf, responseSender) -> {
            RemoveOverlayPayload payload = RemoveOverlayPayload.read(buf);
            client.execute(() -> {
                class_2338 pos = payload.pos();
                class_2680 state = UnderlayManagerClient.getOverlay(pos);
                UnderlayRenderer.unregisterOverlay(pos);
                UnderlayManagerClient.syncRemove(pos);
                client.field_1687.method_8396((class_1657)client.field_1724, pos, state.method_26231().method_10595(), class_3419.field_15245, 1.0f, 1.0f);
            });
        });
        UnderlayRenderer.init();
        ClientPlayConnectionEvents.DISCONNECT.register((handler, cli) -> {
            UnderlayRenderer.clearAllOverlays();
            UnderlayManagerClient.removeAll();
        });
    }

    private void onClientTick(class_310 client) {
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        if (client.field_1755 != null) {
            return;
        }
        this.handleContinuousBreaking(client);
    }

    private void handleContinuousBreaking(class_310 client) {
        if (client.field_1690.field_1886.method_1434()) {
            class_2338 hit = UnderlayClient.findOverlayUnderCrosshair(client);
            ClientPlayerInteractionManagerAccessor playerInteraction = (ClientPlayerInteractionManagerAccessor)client.field_1761;
            if (hit != null && playerInteraction.getBlockBreakingCooldown() == 0) {
                UnderlayClient.breakOverlay(client, hit);
            }
        }
    }

    public static void breakOverlay(class_310 client, class_2338 pos) {
        ClientPlayerInteractionManagerAccessor interactionManager = (ClientPlayerInteractionManagerAccessor)client.field_1761;
        RemoveOverlayPayload payload = new RemoveOverlayPayload(pos);
        class_2540 buf = new class_2540(Unpooled.buffer());
        RemoveOverlayPayload.write(buf, payload);
        class_2540 copy = new class_2540(buf.copy());
        ClientPlayNetworking.send((class_2960)RemoveOverlayPayload.ID, (class_2540)copy);
        interactionManager.setBlockBreakingCooldown(5);
    }

    public static class_2338 findOverlayUnderCrosshair(class_310 client) {
        if (client.field_1724 == null) {
            return null;
        }
        class_3965 overlayHit = UnderlayRaycast.trace((class_1297)client.field_1724, client.field_1761.method_2904(), client.method_1488());
        return overlayHit == null ? null : overlayHit.method_17777();
    }

    private static /* synthetic */ class_2680 lambda$onInitializeClient$0(class_7871 lookup, Map.Entry e) {
        return class_2512.method_10681((class_7871)lookup, (class_2487)((class_2487)e.getValue()));
    }
}

