/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.network;

import com.dooji.underlay.UnderlayManager;
import com.dooji.underlay.network.payloads.AddOverlayPayload;
import com.dooji.underlay.network.payloads.PickItemFromOverlayPayload;
import com.dooji.underlay.network.payloads.RemoveOverlayPayload;
import com.dooji.underlay.network.payloads.SyncOverlaysPayload;
import java.util.HashMap;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2735;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4538;
import net.minecraft.class_8710;

public class UnderlayNetworking {
    public static void init() {
        PayloadTypeRegistry.playS2C().register(SyncOverlaysPayload.ID, SyncOverlaysPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(AddOverlayPayload.ID, AddOverlayPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RemoveOverlayPayload.ID, RemoveOverlayPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(RemoveOverlayPayload.ID, RemoveOverlayPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(PickItemFromOverlayPayload.ID, PickItemFromOverlayPayload.CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> UnderlayNetworking.syncOverlaysToPlayer(handler.method_32311()));
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, from, to) -> UnderlayNetworking.syncOverlaysToPlayer(player));
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> UnderlayNetworking.syncOverlaysToPlayer(newPlayer));
        ServerPlayNetworking.registerGlobalReceiver(RemoveOverlayPayload.ID, (payload, context) -> {
            class_2338 pos;
            class_3222 player = context.player();
            class_3218 world = player.method_51469();
            if (!world.method_8505((class_1297)player, pos = payload.pos())) {
                return;
            }
            if (UnderlayManager.hasOverlay((class_1937)world, pos)) {
                class_2680 old = UnderlayManager.getOverlay((class_1937)world, pos);
                UnderlayManager.removeOverlay((class_1937)world, pos);
                if (!player.method_68878()) {
                    class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)new class_1799((class_1935)old.method_26204()));
                }
                UnderlayNetworking.broadcastRemove(world, pos);
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(PickItemFromOverlayPayload.ID, (payload, context) -> {
            class_2680 overlayState;
            class_1799 itemStack;
            class_2338 pos;
            class_3222 player = context.player();
            class_3218 world = player.method_51469();
            if (!world.method_8505((class_1297)player, pos = payload.pos())) {
                return;
            }
            if (UnderlayManager.hasOverlay((class_1937)world, pos) && !(itemStack = (overlayState = UnderlayManager.getOverlay((class_1937)world, pos)).method_65171((class_4538)world, pos, player.method_68878())).method_7960() && itemStack.method_45435(world.method_45162())) {
                class_1661 playerInventory = player.method_31548();
                int slotWithStack = playerInventory.method_7395(itemStack);
                if (slotWithStack != -1) {
                    if (class_1661.method_7380((int)slotWithStack)) {
                        playerInventory.method_61496(slotWithStack);
                    } else {
                        playerInventory.method_7365(slotWithStack);
                    }
                } else if (player.method_68878()) {
                    playerInventory.method_65126(itemStack);
                }
                player.field_13987.method_14364((class_2596)new class_2735(playerInventory.method_67532()));
                player.field_7498.method_7623();
            }
        });
    }

    public static void syncOverlaysToPlayer(class_3222 player) {
        class_3218 world = player.method_51469();
        HashMap<class_2338, class_2487> tags = new HashMap<class_2338, class_2487>();
        UnderlayManager.getOverlaysFor((class_1937)world).forEach((pos, state) -> tags.put((class_2338)pos, class_2512.method_10686((class_2680)state)));
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncOverlaysPayload(tags));
    }

    public static void broadcastAdd(class_3218 world, class_2338 pos) {
        class_2487 tag = class_2512.method_10686((class_2680)UnderlayManager.getOverlay((class_1937)world, pos));
        AddOverlayPayload payload = new AddOverlayPayload(pos, tag);
        for (class_3222 p : world.method_18456()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)payload);
        }
    }

    private static void broadcastRemove(class_3218 world, class_2338 pos) {
        RemoveOverlayPayload payload = new RemoveOverlayPayload(pos);
        for (class_3222 p : world.method_18456()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)payload);
        }
    }
}

