/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.network;

import com.dooji.underlay.UnderlayManager;
import com.dooji.underlay.network.payloads.AddOverlayPayload;
import com.dooji.underlay.network.payloads.RemoveOverlayPayload;
import com.dooji.underlay.network.payloads.SyncOverlaysPayload;
import java.util.HashMap;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1264;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class UnderlayNetworking {
    public static void init() {
        PayloadTypeRegistry.playS2C().register(SyncOverlaysPayload.ID, SyncOverlaysPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(AddOverlayPayload.ID, AddOverlayPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RemoveOverlayPayload.ID, RemoveOverlayPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(RemoveOverlayPayload.ID, RemoveOverlayPayload.CODEC);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> UnderlayNetworking.syncOverlaysToPlayer(handler.method_32311()));
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, from, to) -> UnderlayNetworking.syncOverlaysToPlayer(player));
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> UnderlayNetworking.syncOverlaysToPlayer(newPlayer));
        ServerPlayNetworking.registerGlobalReceiver(RemoveOverlayPayload.ID, (payload, context) -> {
            class_2338 pos;
            class_3222 player = context.player();
            class_3218 world = (class_3218)player.method_37908();
            if (!world.method_8505((class_1657)player, pos = payload.pos())) {
                return;
            }
            if (UnderlayManager.hasOverlay((class_1937)world, pos)) {
                class_2680 old = UnderlayManager.getOverlay((class_1937)world, pos);
                UnderlayManager.removeOverlay((class_1937)world, pos);
                if (!player.method_7337()) {
                    class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)new class_1799((class_1935)old.method_26204()));
                }
                UnderlayNetworking.broadcastRemove(world, pos);
            }
        });
    }

    public static void syncOverlaysToPlayer(class_3222 player) {
        class_1937 world = player.method_37908();
        HashMap<class_2338, class_2487> tags = new HashMap<class_2338, class_2487>();
        UnderlayManager.getOverlaysFor(world).forEach((pos, state) -> tags.put((class_2338)pos, class_2512.method_10686((class_2680)state)));
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncOverlaysPayload(tags));
    }

    public static void broadcastAdd(class_3218 world, class_2338 pos) {
        class_2487 tag = class_2512.method_10686((class_2680)UnderlayManager.getOverlay((class_1937)world, pos));
        AddOverlayPayload payload = new AddOverlayPayload(pos, tag);
        for (class_3222 p : world.method_18456()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)payload);
        }
    }

    private static void broadcastRemove(class_3218 world, class_2338 pos) {
        RemoveOverlayPayload payload = new RemoveOverlayPayload(pos);
        for (class_3222 p : world.method_18456()) {
            ServerPlayNetworking.send((class_3222)p, (class_8710)payload);
        }
    }
}

