/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay;

import com.dooji.underlay.UnderlayManagerClient;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5819;
import net.minecraft.class_776;

@Environment(value=EnvType.CLIENT)
public class UnderlayRenderer {
    private static final class_5819 RANDOM = class_5819.method_43047();
    private static final Map<class_2338, class_2680> RENDER_CACHE = new ConcurrentHashMap<class_2338, class_2680>();
    private static long lastFullRefreshTime = 0L;
    private static final long FULL_REFRESH_INTERVAL = 500L;

    public static void registerOverlay(class_2338 pos, class_2680 state) {
        RENDER_CACHE.put(pos.method_10062(), state);
    }

    public static void unregisterOverlay(class_2338 pos) {
        RENDER_CACHE.remove(pos);
    }

    public static void clearAllOverlays() {
        RENDER_CACHE.clear();
    }

    public static void forceRefresh() {
        lastFullRefreshTime = System.currentTimeMillis();
        UnderlayRenderer.clearAllOverlays();
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null && client.field_1724 != null) {
            class_2338 playerPos = client.field_1724.method_24515();
            int radius = 64;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -16; y <= 16; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        class_2338 pos = playerPos.method_10069(x, y, z);
                        if (!UnderlayManagerClient.hasOverlay(pos)) continue;
                        UnderlayRenderer.registerOverlay(pos, UnderlayManagerClient.getOverlay(pos));
                    }
                }
            }
        }
    }

    private static void checkForFullRefresh() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastFullRefreshTime > 500L) {
            UnderlayRenderer.forceRefresh();
        }
    }

    public static void renderOverlays() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null || client.field_1724 == null) {
            return;
        }
        class_776 blockRenderer = client.method_1541();
        class_4587 matrices = new class_4587();
        class_4597.class_4598 vertexConsumers = client.method_22940().method_23000();
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        UnderlayRenderer.checkForFullRefresh();
        matrices.method_22903();
        for (Map.Entry<class_2338, class_2680> entry : RENDER_CACHE.entrySet()) {
            class_2338 pos = entry.getKey();
            class_2680 state = entry.getValue();
            int chunks = (Integer)client.field_1690.method_42503().method_41753();
            int blocks = chunks * 16;
            double maxDistSq = (double)blocks * (double)blocks;
            double distanceSq = pos.method_10262((class_2382)client.field_1724.method_24515());
            if (distanceSq > maxDistSq) continue;
            if (!UnderlayManagerClient.hasOverlay(pos)) {
                RENDER_CACHE.remove(pos);
                continue;
            }
            matrices.method_22903();
            matrices.method_22904((double)pos.method_10263() - cameraPos.field_1352, (double)pos.method_10264() - cameraPos.field_1351, (double)pos.method_10260() - cameraPos.field_1350);
            class_1087 model = blockRenderer.method_3351().method_3335(state);
            ArrayList parts = new ArrayList();
            RANDOM.method_43052(state.method_26190(pos));
            model.method_68513(RANDOM, parts);
            class_4588 buffer = vertexConsumers.method_73477(class_1921.method_23579());
            blockRenderer.method_3355(state, pos, (class_1920)client.field_1687, matrices, buffer, true, parts);
            matrices.method_22909();
        }
        matrices.method_22909();
        vertexConsumers.method_22993();
    }
}

