/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike;

import net.critical_strike.api.CriticalStrikeAttributes;
import net.critical_strike.fx.CriticalStrikeSounds;
import net.critical_strike.internal.Config;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.tiny_config.ConfigManager;

public final class CriticalStrikeMod {
    public static final String ID = "critical_strike";
    public static ConfigManager<Config> config = new ConfigManager("server_config", (Object)new Config()).builder().setDirectory("critical_strike").sanitize(true).build();
    public static final int CRIT_PACKET_CODE = 43;

    public static void init() {
        config.refresh();
        CriticalStrikeAttributes.CHANCE.setInnateBonus(((Config)CriticalStrikeMod.config.value).attribute_crit_chance_innate_bonus);
        CriticalStrikeAttributes.CHANCE.setEffectBonus(((Config)CriticalStrikeMod.config.value).effect_crit_chance_per_level);
        CriticalStrikeAttributes.DAMAGE.setInnateBonus(((Config)CriticalStrikeMod.config.value).attribute_crit_damage_innate_bonus);
        CriticalStrikeAttributes.DAMAGE.setEffectBonus(((Config)CriticalStrikeMod.config.value).effect_crit_damage_per_level);
    }

    public static void registerSounds() {
        CriticalStrikeSounds.register();
    }

    public static void registerEffects() {
        for (CriticalStrikeAttributes.Entry entry : CriticalStrikeAttributes.all) {
            entry.registerEffect();
        }
    }

    public static void registerPotions() {
        for (CriticalStrikeAttributes.Entry entry : CriticalStrikeAttributes.all) {
            if (entry.effectEntry == null) continue;
            Potion potion = new Potion(new MobEffectInstance[]{new MobEffectInstance(entry.effectEntry, 3600, 0, false, true)});
            Registry.register((Registry)BuiltInRegistries.POTION, (ResourceLocation)entry.potionId(), (Object)potion);
        }
    }
}

