/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.authlib.GameProfile;
import net.critical_strike.CriticalStrikeMod;
import net.critical_strike.api.CriticalStrikeAttributes;
import net.critical_strike.internal.Config;
import net.critical_strike.internal.CritLogic;
import net.critical_strike.internal.CriticalStriker;
import net.minecraft.core.BlockPos;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
implements CriticalStriker {
    private int critical_chance_time = 0;
    private boolean critical_strike_active = false;

    @Inject(method={"createAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void addAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> info) {
        for (CriticalStrikeAttributes.Entry entry : CriticalStrikeAttributes.all) {
            ((AttributeSupplier.Builder)info.getReturnValue()).add(entry.attributeEntry);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;FLcom/mojang/authlib/GameProfile;)V"}, at={@At(value="TAIL")})
    private void onConstructed(Level world, BlockPos pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        for (CriticalStrikeAttributes.Entry entry : CriticalStrikeAttributes.all) {
            if (entry.innateModifier == null) continue;
            ((Player)this).getAttributes().getInstance(entry.attributeEntry).addPermanentModifier(entry.innateModifier);
        }
    }

    @Override
    public boolean rng_shouldDealCriticalHit() {
        Player player = (Player)this;
        if (((Config)CriticalStrikeMod.config.value).enable_critical_strike_batching) {
            if (this.critical_chance_time != player.tickCount) {
                double chance = this.rng_criticalChance();
                this.critical_strike_active = (double)player.getRandom().nextFloat() < chance;
                this.critical_chance_time = player.tickCount;
            }
            return this.critical_strike_active;
        }
        double chance = this.rng_criticalChance();
        return (double)player.getRandom().nextFloat() < chance;
    }

    @Override
    public double rng_criticalChance() {
        Player player = (Player)this;
        double value = player.getAttributeValue(CriticalStrikeAttributes.CHANCE.attributeEntry);
        return CriticalStrikeAttributes.CHANCE.asChance(value);
    }

    @Override
    public double rng_criticalDamageMultiplier() {
        Player player = (Player)this;
        double value = player.getAttributeValue(CriticalStrikeAttributes.DAMAGE.attributeEntry);
        return CriticalStrikeAttributes.DAMAGE.asMultiplier(value);
    }

    @WrapOperation(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;onGround()Z")})
    private boolean disableVanillaCrit(Player instance, Operation<Boolean> original) {
        Boolean result = (Boolean)original.call(new Object[]{instance});
        return ((Config)CriticalStrikeMod.config.value).disable_vanilla_jump_criticals || result != false;
    }

    @WrapOperation(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z")})
    private boolean applyCriticalStrikeDamage(Entity instance, DamageSource source, float amount, Operation<Boolean> original) {
        Config config = (Config)CriticalStrikeMod.config.value;
        if (!config.enable_melee_criticals) {
            return (Boolean)original.call(new Object[]{instance, source, Float.valueOf(amount)});
        }
        Player attacker = (Player)this;
        if (config.require_weapon_for_critical_strikes && !CritLogic.isWeapon(attacker.getMainHandItem())) {
            return (Boolean)original.call(new Object[]{instance, source, Float.valueOf(amount)});
        }
        CriticalStriker critter = this;
        CritLogic.Result crit = CritLogic.modifyDamage(critter, source, amount);
        if (crit != null) {
            Boolean result = (Boolean)original.call(new Object[]{instance, crit.source(), Float.valueOf(crit.amount() * config.balance_melee_damage_multiplier)});
            if (result.booleanValue()) {
                CritLogic.playFxAt(instance, config.sound_melee_crit_volume);
            }
            return result;
        }
        return (Boolean)original.call(new Object[]{instance, source, Float.valueOf(amount)});
    }
}

