/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.fabric.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;

public abstract class SimpleParticleGenerator
implements class_2405 {
    private final CompletableFuture<class_7225.class_7874> registryLookup;
    protected final FabricDataOutput dataOutput;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public SimpleParticleGenerator(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        this.dataOutput = dataOutput;
        this.registryLookup = registryLookup;
    }

    public abstract void generateSimpleParticles(Builder var1);

    public CompletableFuture<?> method_10319(class_7403 writer) {
        Builder builder = new Builder();
        this.generateSimpleParticles(builder);
        List<Entry> entries = builder.entries;
        ArrayList<CompletableFuture> writes = new ArrayList<CompletableFuture>();
        for (Entry entry : entries) {
            ParticleData data = entry.particle();
            class_2960 id = entry.id;
            JsonElement json = gson.toJsonTree((Object)data);
            Path path = this.getFilePath(id);
            writes.add(class_2405.method_10320((class_7403)writer, (JsonElement)json, (Path)path));
        }
        return CompletableFuture.allOf(writes.toArray(new CompletableFuture[0]));
    }

    public String method_10321() {
        return "Simple Particle Generator";
    }

    private Path getFilePath(class_2960 spellId) {
        return this.dataOutput.method_45973(class_7784.class_7490.field_39368, "particles").method_44107(spellId);
    }

    public static class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();

        public void add(class_2960 id, ParticleData spell) {
            this.entries.add(new Entry(id, spell));
        }
    }

    public record Entry(class_2960 id, ParticleData particle) {
    }

    public record ParticleData(List<String> textures) {
    }
}

