/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.fx;

import java.util.ArrayList;
import net.critical_strike.client.particle.TemplateParticleType;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

public class CriticalStrikeParticles {
    public static final ArrayList<Entry> ENTRIES = new ArrayList();
    public static final ArrayList<TemplateEntry> TEMPLATE_ENTRIES = new ArrayList();
    public static final TemplateEntry SPARKLE = CriticalStrikeParticles.addTemplate(new TemplateEntry("sparkle", Texture.of("sparkle"), new Behaviour(Motion.DECELERATE, false, 10, 0.5f)));
    public static final TemplateEntry SKULL = CriticalStrikeParticles.addTemplate(new TemplateEntry("skull", Texture.of("skull"), new Behaviour(Motion.ASCEND, false, 18, 0.85f).fade(0.05f)));
    public static final TemplateEntry CIRCLE = CriticalStrikeParticles.addTemplate(new TemplateEntry("circle", Texture.of("circle"), new Behaviour(Motion.FLOAT, true, 16, 2.0f).grow(0.08f).fade(0.05f).overlayScale(0.95f)));

    private static SimpleParticleType createSimple() {
        return new Helper(false);
    }

    private static Entry add(Entry simpleEntry) {
        ENTRIES.add(simpleEntry);
        return simpleEntry;
    }

    private static TemplateEntry addTemplate(TemplateEntry entry) {
        TEMPLATE_ENTRIES.add(entry);
        return entry;
    }

    public static void register() {
        for (Entry entry : ENTRIES) {
            Registry.register((Registry)BuiltInRegistries.PARTICLE_TYPE, (ResourceLocation)entry.id, (Object)entry.particleType);
        }
        for (TemplateEntry templateEntry : TEMPLATE_ENTRIES) {
            Registry.register((Registry)BuiltInRegistries.PARTICLE_TYPE, (ResourceLocation)templateEntry.id, (Object)templateEntry.particleType);
        }
    }

    private static class Helper
    extends SimpleParticleType {
        protected Helper(boolean alwaysShow) {
            super(alwaysShow);
        }
    }

    public record Entry(ResourceLocation id, Texture texture, SimpleParticleType particleType) {
        public Entry(String name, Texture texture) {
            this(ResourceLocation.fromNamespaceAndPath((String)"critical_strike", (String)name), texture);
        }

        public Entry(ResourceLocation id, Texture texture) {
            this(id, texture, CriticalStrikeParticles.createSimple());
        }
    }

    public record TemplateEntry(ResourceLocation id, Texture texture, TemplateParticleType particleType, Behaviour behaviour) {
        public TemplateEntry(String name, Texture texture, Behaviour behaviour) {
            this(ResourceLocation.fromNamespaceAndPath((String)"critical_strike", (String)name), texture, new TemplateParticleType(), behaviour);
        }
    }

    public record Texture(ResourceLocation id, int frames) {
        public static Texture vanilla(String name) {
            return new Texture(ResourceLocation.withDefaultNamespace((String)name), 1);
        }

        public static Texture vanilla(String name, int frames) {
            return new Texture(ResourceLocation.withDefaultNamespace((String)name), frames);
        }

        public static Texture of(String name) {
            return new Texture(ResourceLocation.fromNamespaceAndPath((String)"critical_strike", (String)name), 1);
        }
    }

    public record Behaviour(Motion motion, boolean animated, int maxAge, float scale, float overlayScale, float growPerTickDelta, float fadePerTickDelta) {
        public Behaviour(Motion motion, boolean animated, int maxAge, float scale) {
            this(motion, animated, maxAge, scale, 0.8f, 0.0f, 0.0f);
        }

        public Behaviour grow(float growPerTickDelta) {
            return new Behaviour(this.motion, this.animated, this.maxAge, this.scale, this.overlayScale, growPerTickDelta, this.fadePerTickDelta);
        }

        public Behaviour fade(float fadePerTickDelta) {
            return new Behaviour(this.motion, this.animated, this.maxAge, this.scale, this.overlayScale, this.growPerTickDelta, fadePerTickDelta);
        }

        public Behaviour overlayScale(float overlayScale) {
            return new Behaviour(this.motion, this.animated, this.maxAge, this.scale, overlayScale, this.growPerTickDelta, this.fadePerTickDelta);
        }
    }

    public static enum Motion {
        FLOAT,
        ASCEND,
        DECELERATE,
        BURST;

    }
}

