/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.authlib.GameProfile;
import net.critical_strike.CriticalStrikeMod;
import net.critical_strike.api.CriticalStrikeAttributes;
import net.critical_strike.internal.Config;
import net.critical_strike.internal.CritLogic;
import net.critical_strike.internal.CriticalStriker;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5132;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
implements CriticalStriker {
    private int critical_chance_time = 0;
    private boolean critical_strike_active = false;

    @Inject(method={"createPlayerAttributes()Lnet/minecraft/entity/attribute/DefaultAttributeContainer$Builder;"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void addAttributes(CallbackInfoReturnable<class_5132.class_5133> info) {
        for (CriticalStrikeAttributes.Entry entry : CriticalStrikeAttributes.all) {
            ((class_5132.class_5133)info.getReturnValue()).method_26867(entry.attributeEntry);
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onConstructed(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        for (CriticalStrikeAttributes.Entry entry : CriticalStrikeAttributes.all) {
            if (entry.innateModifier == null) continue;
            ((class_1657)this).method_6127().method_45329(entry.attributeEntry).method_26837(entry.innateModifier);
        }
    }

    @Override
    public boolean rng_shouldDealCriticalHit() {
        class_1657 player = (class_1657)this;
        if (((Config)CriticalStrikeMod.config.value).enable_critical_strike_batching) {
            if (this.critical_chance_time != player.field_6012) {
                double chance = this.rng_criticalChance();
                this.critical_strike_active = (double)player.method_59922().method_43057() < chance;
                this.critical_chance_time = player.field_6012;
            }
            return this.critical_strike_active;
        }
        double chance = this.rng_criticalChance();
        return (double)player.method_59922().method_43057() < chance;
    }

    @Override
    public double rng_criticalChance() {
        class_1657 player = (class_1657)this;
        double value = player.method_45325(CriticalStrikeAttributes.CHANCE.attributeEntry);
        return CriticalStrikeAttributes.CHANCE.asChance(value);
    }

    @Override
    public double rng_criticalDamageMultiplier() {
        class_1657 player = (class_1657)this;
        double value = player.method_45325(CriticalStrikeAttributes.DAMAGE.attributeEntry);
        return CriticalStrikeAttributes.DAMAGE.asMultiplier(value);
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;isOnGround()Z")})
    private boolean disableVanillaCrit(class_1657 instance, Operation<Boolean> original) {
        Boolean result = (Boolean)original.call(new Object[]{instance});
        return ((Config)CriticalStrikeMod.config.value).disable_vanilla_jump_criticals ? true : result;
    }

    @WrapOperation(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;damage(Lnet/minecraft/entity/damage/DamageSource;F)Z")})
    private boolean applyCriticalStrikeDamage(class_1297 instance, class_1282 source, float amount, Operation<Boolean> original) {
        Config config = (Config)CriticalStrikeMod.config.value;
        if (!config.enable_melee_criticals) {
            return (Boolean)original.call(new Object[]{instance, source, Float.valueOf(amount)});
        }
        CriticalStriker critter = this;
        CritLogic.Result crit = CritLogic.modifyDamage(critter, source, amount);
        if (crit != null) {
            Boolean result = (Boolean)original.call(new Object[]{instance, crit.source(), Float.valueOf(crit.amount() * config.balance_melee_damage_multiplier)});
            if (result.booleanValue()) {
                CritLogic.playFxAt(instance, config.sound_melee_crit_volume);
            }
            return result;
        }
        return (Boolean)original.call(new Object[]{instance, source, Float.valueOf(amount)});
    }
}

