/*
 * Decompiled with CFR 0.152.
 */
package net.critical_strike.client.util;

public record Color(float red, float green, float blue, float alpha) {
    public static final Color RED = new Color(1.0f, 0.0f, 0.0f);
    public static final Color GREEN = new Color(0.0f, 1.0f, 0.0f);
    public static final Color BLUE = new Color(0.0f, 0.0f, 1.0f);
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f);

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public Color alpha(float alpha) {
        return new Color(this.red, this.green, this.blue, alpha);
    }

    public static Color from(int rgb) {
        float red = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float green = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float blue = (float)(rgb & 0xFF) / 255.0f;
        return new Color(red, green, blue);
    }

    public static Color fromRGBA(long rgba) {
        float red = (float)(rgba >> 24 & 0xFFL) / 255.0f;
        float green = (float)(rgba >> 16 & 0xFFL) / 255.0f;
        float blue = (float)(rgba >> 8 & 0xFFL) / 255.0f;
        float alpha = (float)(rgba & 0xFFL) / 255.0f;
        return new Color(red, green, blue, alpha);
    }

    public Color blend(Color other, float ratio) {
        return Color.blend(this, other, ratio);
    }

    public static Color blend(Color color1, Color color2, float ratio) {
        float red = color1.red * (1.0f - ratio) + color2.red * ratio;
        float green = color1.green * (1.0f - ratio) + color2.green * ratio;
        float blue = color1.blue * (1.0f - ratio) + color2.blue * ratio;
        float alpha = color1.alpha * (1.0f - ratio) + color2.alpha * ratio;
        return new Color(red, green, blue, alpha);
    }

    public IntFormat toIntFormat() {
        return new IntFormat((int)(this.red * 255.0f), (int)(this.green * 255.0f), (int)(this.blue * 255.0f), (int)(this.alpha * 255.0f));
    }

    public ByteFormat toByteFormat() {
        return new ByteFormat((byte)(this.red * 255.0f), (byte)(this.green * 255.0f), (byte)(this.blue * 255.0f), (byte)(this.alpha * 255.0f));
    }

    public long toRGBA() {
        return (long)(this.red * 255.0f) << 24 | (long)(this.green * 255.0f) << 16 | (long)(this.blue * 255.0f) << 8 | (long)(this.alpha * 255.0f);
    }

    public long toARGB() {
        return (long)(this.alpha * 255.0f) << 24 | (long)(this.red * 255.0f) << 16 | (long)(this.green * 255.0f) << 8 | (long)(this.blue * 255.0f);
    }

    public record IntFormat(int red, int green, int blue, int alpha) {
        public static IntFormat fromLongRGBA(long rgba) {
            long red = rgba >> 24 & 0xFFL;
            long green = rgba >> 16 & 0xFFL;
            long blue = rgba >> 8 & 0xFFL;
            long alpha = rgba & 0xFFL;
            return new IntFormat((int)red, (int)green, (int)blue, (int)alpha);
        }
    }

    public record ByteFormat(byte red, byte green, byte blue, byte alpha) {
    }
}

