/*
 * Decompiled with CFR 0.152.
 */
package gh.betterboatcontrols;

import gh.betterboatcontrols.config.BetterBoatControlsConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class BetterBoatControlsClient
implements ClientModInitializer {
    private static int leftTicks = 0;
    private static int rightTicks = 0;
    private static boolean pressingLeft = false;
    private static boolean pressingRight = false;
    public static final String CATEGORY = "key.categories.betterboatcontrols";
    public static final class_304 TOGGLE_BIND = new class_304("key.betterboatcontrols.toggle", class_3675.class_307.field_1668, 345, "key.categories.betterboatcontrols");

    public void onInitializeClient() {
        BetterBoatControlsConfig config = BetterBoatControlsConfig.INSTANCE;
        KeyBindingHelper.registerKeyBinding((class_304)TOGGLE_BIND);
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (TOGGLE_BIND.method_1436()) {
                config.isModEnabled = config.isModEnabled == 1 ? 0 : 1;
                config.save();
                if (client.field_1724 != null && client.field_1687 != null) {
                    String key = config.isModEnabled == 1 ? "message.betterboatcontrols.enabled" : "message.betterboatcontrols.disabled";
                    class_5250 message = class_2561.method_43471((String)key).method_27694(style -> style.method_10977(config.isModEnabled == 1 ? class_124.field_1060 : class_124.field_1061));
                    client.field_1724.method_7353((class_2561)message, true);
                    class_1109 sound = config.isModEnabled == 1 ? class_1109.method_4757((class_3414)class_3417.field_14627, (float)1.0f, (float)0.4f) : class_1109.method_4757((class_3414)((class_3414)class_3417.field_14624.comp_349()), (float)0.8f, (float)0.4f);
                    class_310.method_1551().method_1483().method_4873((class_1113)sound);
                }
            }
            if (client.field_1724 == null || client.field_1687 == null) {
                return;
            }
            class_746 player = client.field_1724;
            class_1297 patt0$temp = player.method_5854();
            if (!(patt0$temp instanceof class_1690)) {
                rightTicks = 0;
                leftTicks = 0;
                pressingRight = false;
                pressingLeft = false;
                return;
            }
            class_1690 boat = (class_1690)patt0$temp;
            boolean aKey = client.field_1690.field_1913.method_1434();
            boolean dKey = client.field_1690.field_1849.method_1434();
            boolean wKey = client.field_1690.field_1894.method_1434();
            boolean sKey = client.field_1690.field_1881.method_1434();
            if (config.isModEnabled == 0) {
                pressingRight = false;
                pressingLeft = false;
                boat.method_64487(aKey, dKey, wKey, sKey);
                return;
            }
            float maxYaw = config.maxYaw;
            float threshold = config.threshold;
            float tickSpeed = config.tickSpeed;
            float deltaYaw = class_3532.method_15393((float)(player.method_36454() - boat.method_36454()));
            if (aKey) {
                pressingLeft = true;
                pressingRight = false;
                rightTicks = 0;
                leftTicks = 0;
            } else if (dKey) {
                pressingRight = true;
                pressingLeft = false;
                rightTicks = 0;
                leftTicks = 0;
            } else {
                double velocity = Math.sqrt(boat.method_18798().method_10216() * boat.method_18798().method_10216() + boat.method_18798().method_10215() * boat.method_18798().method_10215());
                if (velocity < (double)config.minSpeedToTurn) {
                    pressingRight = false;
                    pressingLeft = false;
                    rightTicks = 0;
                    leftTicks = 0;
                    boat.method_64487(false, false, wKey, sKey);
                    return;
                }
                if (deltaYaw < -threshold) {
                    float offset = -deltaYaw - threshold;
                    float ratio = class_3532.method_15363((float)(offset / (maxYaw - threshold)), (float)0.0f, (float)1.0f);
                    if (offset >= maxYaw - threshold) {
                        pressingLeft = true;
                    } else {
                        int pressTicks = Math.max(1, (int)(tickSpeed * (1.0f + ratio * 9.0f)));
                        if (++leftTicks >= pressTicks) {
                            pressingLeft = !pressingLeft;
                            leftTicks = 0;
                        }
                    }
                    pressingRight = false;
                    rightTicks = 0;
                } else if (deltaYaw > threshold) {
                    float offset = deltaYaw - threshold;
                    float ratio = class_3532.method_15363((float)(offset / (maxYaw - threshold)), (float)0.0f, (float)1.0f);
                    if (offset >= maxYaw - threshold) {
                        pressingRight = true;
                    } else {
                        int pressTicks = Math.max(1, (int)(tickSpeed * (1.0f + ratio * 9.0f)));
                        if (++rightTicks >= pressTicks) {
                            pressingRight = !pressingRight;
                            rightTicks = 0;
                        }
                    }
                    pressingLeft = false;
                    leftTicks = 0;
                } else {
                    pressingRight = false;
                    pressingLeft = false;
                    rightTicks = 0;
                    leftTicks = 0;
                }
            }
            boat.method_64487(pressingLeft, pressingRight, wKey, sKey);
        });
    }
}

