/*
 * Decompiled with CFR 0.152.
 */
package gh.betterboatcontrols.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class BetterBoatControlsConfig {
    public int isModEnabled = 1;
    public int maxYaw = 90;
    public int threshold = 5;
    public float tickSpeed = 1.0f;
    public float minSpeedToTurn = 0.01f;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/BetterBoatControlsConfig.json");
    public static BetterBoatControlsConfig INSTANCE = BetterBoatControlsConfig.load();

    private static BetterBoatControlsConfig load() {
        BetterBoatControlsConfig betterBoatControlsConfig;
        if (!CONFIG_FILE.exists()) {
            BetterBoatControlsConfig config = new BetterBoatControlsConfig();
            config.save();
            return config;
        }
        FileReader reader = new FileReader(CONFIG_FILE);
        try {
            betterBoatControlsConfig = (BetterBoatControlsConfig)GSON.fromJson((Reader)reader, BetterBoatControlsConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return new BetterBoatControlsConfig();
            }
        }
        reader.close();
        return betterBoatControlsConfig;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

