/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.genesisforms;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.pc.PCStore;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import com.cobblemon.mod.common.pokemon.Pokemon;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Unit;
import me.unariginal.genesisforms.commands.GenesisCommands;
import me.unariginal.genesisforms.config.BattleFormChangeConfig;
import me.unariginal.genesisforms.config.Config;
import me.unariginal.genesisforms.config.EventsConfig;
import me.unariginal.genesisforms.config.MegaEvolutionConfig;
import me.unariginal.genesisforms.config.MessagesConfig;
import me.unariginal.genesisforms.config.items.MiscItemsConfig;
import me.unariginal.genesisforms.config.items.accessories.AccessoriesConfig;
import me.unariginal.genesisforms.config.items.bagitems.MaxItemsConfig;
import me.unariginal.genesisforms.config.items.bagitems.TeraShardsConfig;
import me.unariginal.genesisforms.config.items.helditems.HeldBattleItemsConfig;
import me.unariginal.genesisforms.config.items.helditems.HeldFormItemsConfig;
import me.unariginal.genesisforms.config.items.helditems.ZCrystalsConfig;
import me.unariginal.genesisforms.config.items.keyitems.FusionItemsConfig;
import me.unariginal.genesisforms.config.items.keyitems.KeyFormItemsConfig;
import me.unariginal.genesisforms.config.items.keyitems.PossessionItemsConfig;
import me.unariginal.genesisforms.handlers.CobblemonEventHandler;
import me.unariginal.genesisforms.handlers.DynamaxHandler;
import me.unariginal.genesisforms.handlers.ScaleHandler;
import me.unariginal.genesisforms.handlers.UltraBurstHandler;
import me.unariginal.genesisforms.polymer.BagItemsGroup;
import me.unariginal.genesisforms.polymer.HeldItemsGroup;
import me.unariginal.genesisforms.polymer.KeyItemsGroup;
import me.unariginal.genesisforms.polymer.MegastonesGroup;
import me.unariginal.genesisforms.polymer.TeraShardsGroup;
import me.unariginal.genesisforms.polymer.ZCrystalsGroup;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenesisForms
implements ModInitializer {
    public static final String MOD_ID = "genesisforms";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"genesisforms");
    public static GenesisForms INSTANCE;
    private MinecraftServer server;
    private FabricServerAudiences audiences;
    private Config config = new Config();
    private MessagesConfig messagesConfig = new MessagesConfig();
    private final Map<UUID, UUID> playersWithMega = new HashMap<UUID, UUID>();

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public void onInitialize() {
        INSTANCE = this;
        new GenesisCommands();
        try {
            AccessoriesConfig.load();
            KeyFormItemsConfig.load();
            HeldFormItemsConfig.load();
            HeldBattleItemsConfig.load();
            MegaEvolutionConfig.load();
            ZCrystalsConfig.load();
            TeraShardsConfig.load();
            FusionItemsConfig.load();
            PossessionItemsConfig.load();
            MaxItemsConfig.load();
            MiscItemsConfig.load();
        }
        catch (IOException e) {
            this.logError("[GenesisForms] " + e.getMessage());
        }
        PolymerResourcePackUtils.markAsRequired();
        PolymerResourcePackUtils.addModAssets((String)MOD_ID);
        this.registerItems();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            this.server = server;
            this.audiences = FabricServerAudiences.of((MinecraftServer)server);
            this.reload();
            this.registerEvents();
        });
    }

    public void reload() {
        this.config = new Config();
        this.messagesConfig = new MessagesConfig();
        try {
            EventsConfig.load();
            BattleFormChangeConfig.load();
        }
        catch (IOException e) {
            this.logError(e.getMessage());
        }
    }

    private void registerItems() {
        KeyItemsGroup.registerItemGroup();
        HeldItemsGroup.registerItemGroup();
        BagItemsGroup.registerItemGroup();
        MegastonesGroup.registerItemGroup();
        TeraShardsGroup.registerItemGroup();
        ZCrystalsGroup.registerItemGroup();
    }

    private void registerEvents() {
        CobblemonEvents.HELD_ITEM_POST.subscribe(Priority.NORMAL, CobblemonEventHandler::heldItemChange);
        CobblemonEvents.POKEMON_RELEASED_EVENT_POST.subscribe(Priority.NORMAL, CobblemonEventHandler::pokemonReleasedEvent);
        CobblemonEvents.POKEMON_GAINED.subscribe(Priority.NORMAL, CobblemonEventHandler::pokemonGainedEvent);
        CobblemonEvents.POKEMON_SENT_POST.subscribe(Priority.NORMAL, CobblemonEventHandler::pokemonSentEvent);
        CobblemonEvents.FORME_CHANGE.subscribe(Priority.NORMAL, CobblemonEventHandler::formChangeEvent);
        CobblemonEvents.MEGA_EVOLUTION.subscribe(Priority.NORMAL, CobblemonEventHandler::megaEvolveEvent);
        CobblemonEvents.TERASTALLIZATION.subscribe(Priority.NORMAL, CobblemonEventHandler::terastallizationEvent);
        CobblemonEvents.ZPOWER_USED.subscribe(Priority.NORMAL, CobblemonEventHandler::zPowerEvent);
        UltraBurstHandler.register();
        DynamaxHandler.register();
        CobblemonEvents.BATTLE_STARTED_PRE.subscribe(Priority.NORMAL, CobblemonEventHandler::battleStartEvent);
        CobblemonEvents.BATTLE_FAINTED.subscribe(Priority.NORMAL, CobblemonEventHandler::battleFaintEvent);
        CobblemonEvents.BATTLE_VICTORY.subscribe(Priority.NORMAL, CobblemonEventHandler::battleEndEvent);
        CobblemonEvents.BATTLE_FLED.subscribe(Priority.NORMAL, CobblemonEventHandler::battleFledEvent);
        ServerTickEvents.END_SERVER_TICK.register(server -> ScaleHandler.updateScales());
        PlatformEvents.SERVER_PLAYER_LOGOUT.subscribe(Priority.NORMAL, event -> {
            this.playersWithMega.remove(event.getPlayer().method_5667());
            return Unit.INSTANCE;
        });
        PlatformEvents.SERVER_PLAYER_LOGIN.subscribe(Priority.NORMAL, event -> {
            class_3222 player = event.getPlayer();
            PlayerPartyStore playerPartyStore = Cobblemon.INSTANCE.getStorage().getParty(player);
            PCStore pcStore = Cobblemon.INSTANCE.getStorage().getPC(player);
            List<Pokemon> megaPokemonInParty = playerPartyStore.toGappyList().stream().filter(pokemon -> {
                if (pokemon == null) {
                    return false;
                }
                MegaEvolutionConfig.MegaEvolutionData megastoneData = MegaEvolutionConfig.getMegaEvolution(pokemon);
                if (megastoneData == null) {
                    return false;
                }
                return pokemon.getFeatures().stream().anyMatch(speciesFeature -> {
                    if (speciesFeature.getName().equalsIgnoreCase(megastoneData.featureName)) {
                        if (speciesFeature instanceof StringSpeciesFeature) {
                            StringSpeciesFeature stringSpeciesFeature = (StringSpeciesFeature)speciesFeature;
                            return stringSpeciesFeature.getValue().equalsIgnoreCase(megastoneData.featureValue);
                        }
                        if (speciesFeature instanceof FlagSpeciesFeature) {
                            FlagSpeciesFeature flagSpeciesFeature = (FlagSpeciesFeature)speciesFeature;
                            return Boolean.toString(flagSpeciesFeature.getEnabled()).equalsIgnoreCase(megastoneData.featureValue);
                        }
                    }
                    return false;
                });
            }).toList();
            for (Pokemon pokemon2 : megaPokemonInParty) {
                if (pokemon2 == null) continue;
                if (this.playersWithMega.containsKey(player.method_5667())) {
                    CobblemonEventHandler.revertForm(pokemon2, false);
                    continue;
                }
                this.playersWithMega.put(player.method_5667(), pokemon2.getUuid());
            }
            ArrayList megaPokemonInPC = new ArrayList();
            pcStore.getBoxes().forEach(pcBox -> pcBox.getNonEmptySlots().values().forEach(pokemon -> {
                MegaEvolutionConfig.MegaEvolutionData megastoneData;
                if (pokemon != null && !megaPokemonInPC.contains(pokemon) && (megastoneData = MegaEvolutionConfig.getMegaEvolution(pokemon)) != null && pokemon.getFeatures().stream().anyMatch(speciesFeature -> {
                    if (speciesFeature.getName().equalsIgnoreCase(megastoneData.featureName)) {
                        if (speciesFeature instanceof StringSpeciesFeature) {
                            StringSpeciesFeature stringSpeciesFeature = (StringSpeciesFeature)speciesFeature;
                            return stringSpeciesFeature.getValue().equalsIgnoreCase(megastoneData.featureValue);
                        }
                        if (speciesFeature instanceof FlagSpeciesFeature) {
                            FlagSpeciesFeature flagSpeciesFeature = (FlagSpeciesFeature)speciesFeature;
                            return Boolean.toString(flagSpeciesFeature.getEnabled()).equalsIgnoreCase(megastoneData.featureValue);
                        }
                    }
                    return false;
                })) {
                    megaPokemonInPC.add(pokemon);
                }
            }));
            for (Pokemon pokemon3 : megaPokemonInPC) {
                if (pokemon3 == null) continue;
                if (this.playersWithMega.containsKey(player.method_5667())) {
                    CobblemonEventHandler.revertForm(pokemon3, false);
                    continue;
                }
                this.playersWithMega.put(player.method_5667(), pokemon3.getUuid());
            }
            return Unit.INSTANCE;
        });
    }

    public void logError(String message) {
        LOGGER.error(message);
    }

    public void logInfo(String message) {
        if (this.config.debug) {
            LOGGER.info(message);
        }
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public FabricServerAudiences getAudiences() {
        return this.audiences;
    }

    public Config getConfig() {
        return this.config;
    }

    public MessagesConfig getMessagesConfig() {
        return this.messagesConfig;
    }

    public Map<UUID, UUID> getPlayersWithMega() {
        return this.playersWithMega;
    }
}

