/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.genesisforms.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import me.unariginal.genesisforms.GenesisForms;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    public boolean debug = false;
    public List<String> disabledItems = new ArrayList<String>();
    public boolean enableMegaEvolution = true;
    public boolean alwaysModifyTradeableProperty = true;
    public boolean enableTera = true;
    public boolean enableZCrystals = true;
    public boolean enableDynamax = true;
    public boolean enableGigantamax = true;
    public boolean enableFusions = true;
    public boolean allowMegaOutsideBattles = true;
    public boolean fixOgerponTeraType = true;
    public boolean fixTerapagosTeraType = true;
    public int teraShardsRequired = 50;
    public boolean consumeTeraShards = true;
    public boolean requireOrbRecharge = true;
    public boolean useHotbarInventory = true;
    public boolean useMainInventory = true;
    public boolean useMainHandInventory = true;
    public boolean useOffHandInventory = true;
    public boolean useArmorInventory = false;
    public List<Integer> specificSlots = new ArrayList<Integer>();

    public Config() {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            GenesisForms.INSTANCE.logError("[Genesis] Failed to load config file. Error: " + e.getMessage());
        }
    }

    public void loadConfig() throws IOException {
        JsonArray specificSlots;
        File oldMegastoneConfig;
        File oldItemSettings;
        File oldAnimations;
        File rootFolder = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms").toFile();
        if (!rootFolder.exists()) {
            rootFolder.mkdirs();
        }
        if ((oldAnimations = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/animations.json").toFile()).exists()) {
            oldAnimations.renameTo(FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/old_animations.json").toFile());
        }
        if ((oldItemSettings = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/item_settings.json").toFile()).exists()) {
            oldItemSettings.renameTo(FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/old_item_settings.json").toFile());
        }
        if ((oldMegastoneConfig = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/items/held_items/megastones.json").toFile()).exists()) {
            oldMegastoneConfig.renameTo(FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/items/held_items/old_megastones.json").toFile());
        }
        File configFile = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/config.json").toFile();
        JsonObject newRoot = new JsonObject();
        JsonObject root = new JsonObject();
        if (configFile.exists()) {
            root = JsonParser.parseReader((Reader)new FileReader(configFile)).getAsJsonObject();
        }
        if (root.has("debug")) {
            this.debug = root.get("debug").getAsBoolean();
        }
        newRoot.addProperty("debug", Boolean.valueOf(this.debug));
        JsonObject generalSettings = new JsonObject();
        JsonObject newGeneralSettings = new JsonObject();
        if (root.has("general_settings")) {
            generalSettings = root.get("general_settings").getAsJsonObject();
        }
        JsonObject keyItemSlots = new JsonObject();
        JsonObject newKeyItemSlots = new JsonObject();
        if (root.has("key_item_slots")) {
            keyItemSlots = root.get("key_item_slots").getAsJsonObject();
        }
        if (keyItemSlots.has("hotbar")) {
            this.useHotbarInventory = keyItemSlots.get("hotbar").getAsBoolean();
        }
        newKeyItemSlots.addProperty("hotbar", Boolean.valueOf(this.useHotbarInventory));
        if (keyItemSlots.has("main")) {
            this.useMainInventory = keyItemSlots.get("main").getAsBoolean();
        }
        newKeyItemSlots.addProperty("main", Boolean.valueOf(this.useMainInventory));
        if (keyItemSlots.has("mainhand")) {
            this.useMainHandInventory = keyItemSlots.get("mainhand").getAsBoolean();
        }
        newKeyItemSlots.addProperty("mainhand", Boolean.valueOf(this.useMainHandInventory));
        if (keyItemSlots.has("offhand")) {
            this.useOffHandInventory = keyItemSlots.get("offhand").getAsBoolean();
        }
        newKeyItemSlots.addProperty("offhand", Boolean.valueOf(this.useOffHandInventory));
        if (keyItemSlots.has("armor")) {
            this.useArmorInventory = keyItemSlots.get("armor").getAsBoolean();
        }
        newKeyItemSlots.addProperty("armor", Boolean.valueOf(this.useArmorInventory));
        if (keyItemSlots.has("specific")) {
            specificSlots = keyItemSlots.get("specific").getAsJsonArray();
            for (JsonElement element2 : specificSlots) {
                this.specificSlots.add(element2.getAsInt());
            }
        }
        specificSlots = new JsonArray();
        for (int slot : this.specificSlots) {
            specificSlots.add((Number)slot);
        }
        newKeyItemSlots.add("specific", (JsonElement)specificSlots);
        newGeneralSettings.add("key_item_slots", (JsonElement)newKeyItemSlots);
        JsonArray disabledItems = new JsonArray();
        if (generalSettings.has("disabled_items")) {
            this.disabledItems.clear();
            generalSettings.get("disabled_items").getAsJsonArray().forEach(element -> disabledItems.add(element.getAsString()));
        }
        for (String item : this.disabledItems) {
            disabledItems.add(item);
        }
        newGeneralSettings.add("disabled_items", (JsonElement)disabledItems);
        newRoot.add("general_settings", (JsonElement)newGeneralSettings);
        JsonObject megaSettings = new JsonObject();
        JsonObject newMegaSettings = new JsonObject();
        if (root.has("mega_settings")) {
            megaSettings = root.get("mega_settings").getAsJsonObject();
        }
        if (megaSettings.has("enable_mega_evolution")) {
            this.enableMegaEvolution = megaSettings.get("enable_mega_evolution").getAsBoolean();
        }
        newMegaSettings.addProperty("enable_mega_evolution", Boolean.valueOf(this.enableMegaEvolution));
        if (megaSettings.has("allow_mega_outside_battles")) {
            this.allowMegaOutsideBattles = megaSettings.get("allow_mega_outside_battles").getAsBoolean();
        }
        newMegaSettings.addProperty("allow_mega_outside_battles", Boolean.valueOf(this.allowMegaOutsideBattles));
        if (megaSettings.has("always_modify_tradeable_property")) {
            this.alwaysModifyTradeableProperty = megaSettings.get("always_modify_tradeable_property").getAsBoolean();
        }
        newMegaSettings.addProperty("always_modify_tradeable_property", Boolean.valueOf(this.alwaysModifyTradeableProperty));
        newRoot.add("mega_settings", (JsonElement)newMegaSettings);
        JsonObject zPowerSettings = new JsonObject();
        JsonObject newZPowerSettings = new JsonObject();
        if (root.has("z_power_settings")) {
            zPowerSettings = root.get("z_power_settings").getAsJsonObject();
        }
        if (zPowerSettings.has("enable_z_crystals")) {
            this.enableZCrystals = zPowerSettings.get("enable_z_crystals").getAsBoolean();
        }
        newZPowerSettings.addProperty("enable_z_crystals", Boolean.valueOf(this.enableZCrystals));
        newRoot.add("z_power_settings", (JsonElement)newZPowerSettings);
        JsonObject teraSettings = new JsonObject();
        JsonObject newTeraSettings = new JsonObject();
        if (root.has("tera_settings")) {
            teraSettings = root.get("tera_settings").getAsJsonObject();
        }
        if (teraSettings.has("enable_tera")) {
            this.enableTera = teraSettings.get("enable_tera").getAsBoolean();
        }
        newTeraSettings.addProperty("enable_tera", Boolean.valueOf(this.enableTera));
        if (teraSettings.has("tera_shards_required")) {
            this.teraShardsRequired = teraSettings.get("tera_shards_required").getAsInt();
        }
        if (this.teraShardsRequired > 64) {
            this.teraShardsRequired = 64;
        }
        if (this.teraShardsRequired < 1) {
            this.teraShardsRequired = 1;
        }
        newTeraSettings.addProperty("tera_shards_required", (Number)this.teraShardsRequired);
        if (teraSettings.has("consume_tera_shards")) {
            this.consumeTeraShards = teraSettings.get("consume_tera_shards").getAsBoolean();
        }
        newTeraSettings.addProperty("consume_tera_shards", Boolean.valueOf(this.consumeTeraShards));
        if (teraSettings.has("require_orb_recharge")) {
            this.requireOrbRecharge = teraSettings.get("require_orb_recharge").getAsBoolean();
        }
        newTeraSettings.addProperty("require_orb_recharge", Boolean.valueOf(this.requireOrbRecharge));
        if (teraSettings.has("fix_ogerpon_tera_type")) {
            this.fixOgerponTeraType = teraSettings.get("fix_ogerpon_tera_type").getAsBoolean();
        }
        newTeraSettings.addProperty("fix_ogerpon_tera_type", Boolean.valueOf(this.fixOgerponTeraType));
        if (teraSettings.has("fix_terapagos_tera_type")) {
            this.fixTerapagosTeraType = teraSettings.get("fix_terapagos_tera_type").getAsBoolean();
        }
        newTeraSettings.addProperty("fix_terapagos_tera_type", Boolean.valueOf(this.fixTerapagosTeraType));
        newRoot.add("tera_settings", (JsonElement)newTeraSettings);
        JsonObject fusionSettings = new JsonObject();
        JsonObject newFusionSettings = new JsonObject();
        if (root.has("fusion_settings")) {
            fusionSettings = root.get("fusion_settings").getAsJsonObject();
        }
        if (fusionSettings.has("enable_fusions")) {
            this.enableFusions = fusionSettings.get("enable_fusions").getAsBoolean();
        }
        newFusionSettings.addProperty("enable_fusions", Boolean.valueOf(this.enableFusions));
        newRoot.add("fusion_settings", (JsonElement)newFusionSettings);
        JsonObject dynamaxSettings = new JsonObject();
        JsonObject newDynamaxSettings = new JsonObject();
        if (root.has("dynamax_settings")) {
            dynamaxSettings = root.get("dynamax_settings").getAsJsonObject();
        }
        if (dynamaxSettings.has("enable_dynamax")) {
            this.enableDynamax = dynamaxSettings.get("enable_dynamax").getAsBoolean();
        }
        newDynamaxSettings.addProperty("enable_dynamax", Boolean.valueOf(this.enableDynamax));
        if (dynamaxSettings.has("enable_gigantamax")) {
            this.enableGigantamax = dynamaxSettings.get("enable_gigantamax").getAsBoolean();
        }
        newDynamaxSettings.addProperty("enable_gigantamax", Boolean.valueOf(this.enableGigantamax));
        newRoot.add("dynamax_settings", (JsonElement)newDynamaxSettings);
        configFile.delete();
        configFile.createNewFile();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        FileWriter writer = new FileWriter(configFile);
        gson.toJson((JsonElement)newRoot, (Appendable)writer);
        ((Writer)writer).close();
    }
}

