/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.genesisforms.config;

import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Map;
import kotlin.Unit;
import me.unariginal.genesisforms.handlers.GlowHandler;
import me.unariginal.genesisforms.handlers.ScaleHandler;
import me.unariginal.genesisforms.utils.ConfigUtils;
import me.unariginal.genesisforms.utils.ParticleUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_5134;
import net.minecraft.class_5321;

public class EventsConfig {
    public static GimmickEvents gimmickEvents;

    public static void load() throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String json = "{}";
        File eventsConfigFile = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/events.json").toFile();
        if (!eventsConfigFile.exists()) {
            File configFilePath = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/").toFile();
            configFilePath.mkdirs();
            ConfigUtils.create(eventsConfigFile, "/genesis_configs/events.json");
        }
        if (eventsConfigFile.exists()) {
            json = JsonParser.parseReader((Reader)new FileReader(eventsConfigFile)).toString();
        }
        Type eventsDataType = new TypeToken<GimmickEvents>(){}.getType();
        gimmickEvents = (GimmickEvents)gson.fromJson(json, eventsDataType);
    }

    public static class GimmickEvents {
        @SerializedName(value="mega_evolution", alternate={"megaEvolution"})
        public EventData megaEvolution;
        public EventData terastallization;
        @SerializedName(value="z_power", alternate={"zPower"})
        public EventData zPower;
        public EventData dynamax;

        public GimmickEvents(EventData megaEvolution, EventData terastallization, EventData zPower, EventData dynamax) {
            this.megaEvolution = megaEvolution;
            this.terastallization = terastallization;
            this.zPower = zPower;
            this.dynamax = dynamax;
        }
    }

    public static class ScaleData {
        public float scale;
        @SerializedName(value="scaling_ticks", alternate={"scalingTicks"})
        public long scalingTicks;

        public ScaleData(float scale, long scalingTicks) {
            this.scale = scale;
            this.scalingTicks = scalingTicks;
        }
    }

    public static class FeatureData {
        @SerializedName(value="feature_name", alternate={"featureName"})
        public String featureName;
        @SerializedName(value="feature_value", alternate={"featureValue"})
        public String featureValue;
        @SerializedName(value="default_value", alternate={"defaultValue"})
        public String defaultValue;

        public FeatureData(String featureName, String featureValue, String defaultValue) {
            this.featureName = featureName;
            this.featureValue = featureValue;
            this.defaultValue = defaultValue;
        }
    }

    public static class AnimationData {
        public String identifier;
        @SerializedName(value="form_delay_seconds", alternate={"formDelaySeconds"})
        public float formDelaySeconds;

        public AnimationData(String identifier, float formDelaySeconds) {
            this.identifier = identifier;
            this.formDelaySeconds = formDelaySeconds;
        }
    }

    public static class EventData {
        public Map<String, AnimationData> animations;
        public Map<String, String> glow;
        public Map<String, FeatureData> features;
        public Map<String, ScaleData> scale;

        public EventData(Map<String, AnimationData> animations, Map<String, String> glow, Map<String, FeatureData> features, Map<String, ScaleData> scale) {
            this.animations = animations;
            this.glow = glow;
            this.features = features;
            this.scale = scale;
        }

        public void runEvent(String id, Pokemon pokemon, PokemonEntity pokemonEntity) {
            class_1324 scaleAttribute;
            AnimationData animationData = this.getAnimation(id);
            FeatureData featureData = this.getFeature(id);
            ScaleData scaleData = this.getScale(id);
            float delay = 0.0f;
            if (pokemonEntity != null && animationData != null) {
                ParticleUtils.spawnParticle(animationData.identifier, pokemonEntity.method_19538().method_1031(0.0, pokemonEntity.method_5829().method_17940() / 2.0, 0.0), (class_5321<class_1937>)pokemonEntity.method_37908().method_27983());
                delay = animationData.formDelaySeconds;
            }
            if (featureData != null) {
                if (pokemonEntity != null) {
                    pokemonEntity.after(delay, () -> {
                        if (featureData.featureValue.equalsIgnoreCase("true") || featureData.featureValue.equalsIgnoreCase("false")) {
                            new FlagSpeciesFeature(featureData.featureName, Boolean.getBoolean(featureData.featureValue)).apply(pokemon);
                        } else {
                            new StringSpeciesFeature(featureData.featureName, featureData.featureValue).apply(pokemon);
                        }
                        return Unit.INSTANCE;
                    });
                } else if (featureData.featureValue.equalsIgnoreCase("true") || featureData.featureValue.equalsIgnoreCase("false")) {
                    new FlagSpeciesFeature(featureData.featureName, Boolean.getBoolean(featureData.featureValue)).apply(pokemon);
                } else {
                    new StringSpeciesFeature(featureData.featureName, featureData.featureValue).apply(pokemon);
                }
            }
            if (pokemonEntity != null && scaleData != null && (scaleAttribute = pokemonEntity.method_5996(class_5134.field_47760)) != null) {
                ScaleHandler.scalingAnimations.put(pokemonEntity, new ScaleHandler.ScalingData((float)scaleAttribute.method_6201(), scaleData.scale, scaleData.scalingTicks));
            }
            String glowColor = null;
            if (this.glow.containsKey(id)) {
                glowColor = this.glow.get(id);
            } else if (this.glow.containsKey("global")) {
                glowColor = this.glow.get("global");
            }
            if (glowColor != null) {
                pokemon.getPersistentData().method_10582("glow_id", id);
                pokemon.getPersistentData().method_10582("glow_color", glowColor);
                if (pokemonEntity != null) {
                    GlowHandler.applyGlowing(id, glowColor, pokemon, pokemonEntity);
                }
            }
        }

        public void revertEvent(String id, Pokemon pokemon, PokemonEntity pokemonEntity) {
            class_1324 scaleAttribute;
            FeatureData featureData = this.getFeature(id);
            ScaleData scaleData = this.getScale(id);
            if (featureData != null) {
                pokemon.getFeatures().removeIf(speciesFeature -> speciesFeature.getName().equalsIgnoreCase(featureData.featureName));
                if (featureData.defaultValue != null && !featureData.defaultValue.equalsIgnoreCase("null")) {
                    if (featureData.defaultValue.equalsIgnoreCase("true") || featureData.defaultValue.equalsIgnoreCase("false")) {
                        new FlagSpeciesFeature(featureData.featureName, Boolean.getBoolean(featureData.defaultValue)).apply(pokemon);
                    } else {
                        new StringSpeciesFeature(featureData.featureName, featureData.defaultValue).apply(pokemon);
                    }
                }
            }
            if (pokemonEntity != null && scaleData != null && (scaleAttribute = pokemonEntity.method_5996(class_5134.field_47760)) != null) {
                ScaleHandler.scalingAnimations.put(pokemonEntity, new ScaleHandler.ScalingData((float)scaleAttribute.method_6201(), 1.0f, scaleData.scalingTicks));
            }
            if (pokemon.getPersistentData().method_10545("glow_id")) {
                pokemon.getPersistentData().method_10551("glow_id");
            }
            if (pokemon.getPersistentData().method_10545("glow_color")) {
                pokemon.getPersistentData().method_10551("glow_color");
            }
            GlowHandler.removeGlowing(id, pokemon, pokemonEntity);
        }

        public AnimationData getAnimation(String animationName) {
            if (this.animations.containsKey(animationName)) {
                return this.animations.get(animationName);
            }
            return this.animations.get("global");
        }

        public String getGlow(String glowName) {
            if (this.glow.containsKey(glowName)) {
                return this.glow.get(glowName);
            }
            return this.glow.get("global");
        }

        public FeatureData getFeature(String featureName) {
            if (this.features.containsKey(featureName)) {
                return this.features.get(featureName);
            }
            return this.features.get("global");
        }

        public ScaleData getScale(String scaleName) {
            if (this.scale.containsKey(scaleName)) {
                return this.scale.get(scaleName);
            }
            return this.scale.get("global");
        }
    }
}

