/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.genesisforms.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import me.unariginal.genesisforms.GenesisForms;
import net.fabricmc.loader.api.FabricLoader;

public class MessagesConfig {
    public String prefix = "<dark_gray>[<#35DEC6>Genesis<dark_gray>]";
    public String teraToastTitle = "Tera Type: %pokemon.tera_type%";
    public String teraToastDescription = "";
    public boolean teraToastUseShardIcon = true;
    public float teraToastDisplaySeconds = 3.0f;
    public final Map<String, String> messages = new HashMap<String, String>();

    public MessagesConfig() {
        this.fillMessages();
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            GenesisForms.INSTANCE.logError("[Genesis] Failed to load messages config file. Error: " + e.getMessage());
        }
    }

    public void fillMessages() {
        this.messages.clear();
        this.messages.put("reload_command", "%prefix% <green>Reloaded!");
        this.messages.put("reset_data_command", "%prefix% <green>Reset %player%'s Internal Form Data!");
        this.messages.put("give_command_received", "%prefix% <green>Received %item%!");
        this.messages.put("give_command_feedback", "%prefix% <green>Gave %item% to %player%!");
        this.messages.put("cube_mode_feedback", "<gray>Cube Mode: <green>%cube_mode%");
        this.messages.put("gmax_factor_applied", "<green>%pokemon% can now Gigantamax!");
        this.messages.put("gmax_factor_removed", "<red>%pokemon% can no longer Gigantamax!");
        this.messages.put("has_gmax_factor", "<green>%pokemon% can Gigantamax!");
        this.messages.put("does_not_have_gmax_factor", "<red>%pokemon% can not Gigantamax!");
        this.messages.put("tera_type_changed", "<green>Set %pokemon%'s tera type to %pokemon.tera_type%!");
        this.messages.put("dynamax_level_changed", "<green>%pokemon%'s dynamax level is now %pokemon.dmax_level%!");
    }

    public void loadConfig() throws IOException {
        File rootFolder = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms").toFile();
        if (!rootFolder.exists()) {
            rootFolder.mkdirs();
        }
        File messagesFile = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/messages.json").toFile();
        JsonObject newRoot = new JsonObject();
        JsonObject root = new JsonObject();
        if (messagesFile.exists()) {
            root = JsonParser.parseReader((Reader)new FileReader(messagesFile)).getAsJsonObject();
        }
        if (root.has("prefix")) {
            this.prefix = root.get("prefix").getAsString();
        }
        newRoot.addProperty("prefix", this.prefix);
        JsonObject messages = new JsonObject();
        if (root.has("messages")) {
            messages = root.getAsJsonObject("messages");
        }
        JsonObject teraToast = new JsonObject();
        if (root.has("tera_toast_settings")) {
            teraToast = root.getAsJsonObject("tera_toast_settings");
        }
        if (teraToast.has("toast_title")) {
            this.teraToastTitle = teraToast.get("toast_title").getAsString();
        }
        teraToast.addProperty("toast_title", this.teraToastTitle);
        if (teraToast.has("toast_description")) {
            this.teraToastDescription = teraToast.get("toast_description").getAsString();
        }
        teraToast.addProperty("toast_description", this.teraToastDescription);
        if (teraToast.has("use_shard_icon")) {
            this.teraToastUseShardIcon = teraToast.get("use_shard_icon").getAsBoolean();
        }
        teraToast.addProperty("use_shard_icon", Boolean.valueOf(this.teraToastUseShardIcon));
        if (teraToast.has("display_seconds")) {
            this.teraToastDisplaySeconds = teraToast.get("display_seconds").getAsFloat();
        }
        teraToast.addProperty("display_seconds", (Number)Float.valueOf(this.teraToastDisplaySeconds));
        newRoot.add("tera_toast_settings", (JsonElement)teraToast);
        for (String key : messages.keySet()) {
            if (!messages.has(key)) continue;
            this.messages.put(key, messages.get(key).getAsString());
        }
        for (String key : this.messages.keySet()) {
            messages.addProperty(key, this.messages.get(key));
        }
        newRoot.add("messages", (JsonElement)messages);
        messagesFile.delete();
        messagesFile.createNewFile();
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        FileWriter writer = new FileWriter(messagesFile);
        gson.toJson((JsonElement)newRoot, (Appendable)writer);
        ((Writer)writer).close();
    }

    public String getMessage(String key) {
        if (this.messages.containsKey(key)) {
            return this.messages.get(key);
        }
        return "<red>Failed to load message with key \"" + key + "\".";
    }
}

