/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.genesisforms.config.items;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import me.unariginal.genesisforms.utils.ConfigUtils;
import net.fabricmc.loader.api.FabricLoader;

public class MiscItemsConfig {
    public static MiscItemData miscItemData;

    public static void load() throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
        String json = "{}";
        File miscItemsConfigFile = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/items/misc_items.json").toFile();
        if (!miscItemsConfigFile.exists()) {
            File configFilePath = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/items/").toFile();
            configFilePath.mkdirs();
            ConfigUtils.create(miscItemsConfigFile, "/genesis_configs/items/misc_items.json");
        }
        if (miscItemsConfigFile.exists()) {
            json = JsonParser.parseReader((Reader)new FileReader(miscItemsConfigFile)).toString();
        }
        miscItemData = (MiscItemData)gson.fromJson(json, MiscItemData.class);
        MiscItemsConfig.miscItemData.featureless.values().forEach(item -> {
            if (item.maxCount == null) {
                item.maxCount = 1;
            }
            if (item.lore == null) {
                item.lore = new ArrayList<String>();
            }
        });
        if (!MiscItemsConfig.miscItemData.featureless.containsKey("mega_shard")) {
            MiscItemsConfig.miscItemData.featureless.put("mega_shard", new MiscItem(64, List.of("<gray>A mysterious shard that can be found after smashing Mega Crystals using Pok\u00e9mon moves.", "<gray>It seems that some people collect these shards.")));
        }
        MiscItemsConfig.save();
    }

    public static void save() throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().serializeNulls().create();
        FileWriter writer = new FileWriter("config/GenesisForms/items/misc_items.json");
        gson.toJson((Object)miscItemData, MiscItemData.class, (Appendable)writer);
        writer.close();
    }

    public static class MiscItemData {
        @SerializedName(value="zygarde_cube", alternate={"zygardeCube"})
        public ZygardeCubeData zygardeCube;
        public LinkedHashMap<String, MiscItem> featureless;

        public MiscItemData(ZygardeCubeData zygardeCube, LinkedHashMap<String, MiscItem> featureless) {
            this.zygardeCube = zygardeCube;
            this.featureless = featureless;
        }
    }

    public static class MiscItem {
        @SerializedName(value="max_count", alternate={"maxCount"})
        public Integer maxCount;
        public List<String> lore;

        public MiscItem(int maxCount, List<String> lore) {
            this.maxCount = maxCount;
            this.lore = lore;
        }
    }

    public static class ZygardeCubeData {
        @SerializedName(value="enable_ability_swap", alternate={"enableAbilitySwap"})
        public Boolean enableAbilitySwap;
        @SerializedName(value="enable_form_swap", alternate={"enableFormSwap"})
        public Boolean enableFormSwap;
        @SerializedName(value="feature_name", alternate={"featureName"})
        public String featureName;
        @SerializedName(value="feature_values", alternate={"featureValues"})
        public List<String> featureValues;
        public List<String> lore;

        public ZygardeCubeData(boolean enableAbilitySwap, boolean enableFormSwap, String featureName, List<String> featureValues, List<String> lore) {
            this.enableAbilitySwap = enableAbilitySwap;
            this.enableFormSwap = enableFormSwap;
            this.featureName = featureName;
            this.featureValues = featureValues;
            this.lore = lore;
        }
    }
}

