/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.genesisforms.config.items.helditems;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.List;
import me.unariginal.genesisforms.data.FormSetting;
import me.unariginal.genesisforms.utils.ConfigUtils;
import net.fabricmc.loader.api.FabricLoader;

public class ZCrystalsConfig {
    public static ZCrystalData zCrystalData;

    public static void load() throws IOException {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String json = "{}";
        File zCrystalConfigFile = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/items/held_items/z_crystals.json").toFile();
        if (!zCrystalConfigFile.exists()) {
            File configFilePath = FabricLoader.getInstance().getConfigDir().resolve("GenesisForms/items/held_items/").toFile();
            configFilePath.mkdirs();
            ConfigUtils.create(zCrystalConfigFile, "/genesis_configs/items/held_items/z_crystals.json");
        }
        if (zCrystalConfigFile.exists()) {
            json = JsonParser.parseReader((Reader)new FileReader(zCrystalConfigFile)).toString();
        }
        zCrystalData = (ZCrystalData)gson.fromJson(json, ZCrystalData.class);
    }

    public static class ZCrystalData {
        @SerializedName(value="typed")
        public LinkedHashMap<String, TypedZCrystalData> typedZCrystalMap;
        @SerializedName(value="species")
        public LinkedHashMap<String, SpeciesZCrystalData> speciesZCrystalMap;

        public ZCrystalData(LinkedHashMap<String, TypedZCrystalData> typedZCrystalMap, LinkedHashMap<String, SpeciesZCrystalData> speciesZCrystalMap) {
            this.typedZCrystalMap = typedZCrystalMap;
            this.speciesZCrystalMap = speciesZCrystalMap;
        }
    }

    public static class SpeciesZCrystalData {
        @SerializedName(value="showdown_id", alternate={"showdownId", "showdownID", "showdownid"})
        public String showdownID;
        public List<String> lore;

        public SpeciesZCrystalData(String showdownID, List<String> lore) {
            this.showdownID = showdownID;
            this.lore = lore;
        }
    }

    public static class TypedZCrystalData {
        @SerializedName(value="showdown_id", alternate={"showdownId", "showdownID", "showdownid"})
        public String showdownID;
        public String type;
        @SerializedName(value="form_changes", alternate={"formChanges"})
        public List<FormSetting> formChanges;
        public List<String> lore;

        public TypedZCrystalData(String showdownID, String type, List<FormSetting> formChanges, List<String> lore) {
            this.showdownID = showdownID;
            this.type = type;
            this.formChanges = formChanges;
            this.lore = lore;
        }

        public String toString() {
            return "Showdown ID: " + this.showdownID + "\nType: " + this.type + "\nForm Changes: " + String.valueOf(this.formChanges) + "\nLore: " + String.valueOf(this.lore);
        }
    }
}

