/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.genesisforms.handlers;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.abilities.AbilityTemplate;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.events.battles.BattleFaintedEvent;
import com.cobblemon.mod.common.api.events.battles.BattleFledEvent;
import com.cobblemon.mod.common.api.events.battles.BattleStartedPreEvent;
import com.cobblemon.mod.common.api.events.battles.BattleVictoryEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.FormeChangeEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.MegaEvolutionEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.TerastallizationEvent;
import com.cobblemon.mod.common.api.events.battles.instruction.ZMoveUsedEvent;
import com.cobblemon.mod.common.api.events.pokemon.HeldItemEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonGainedEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonSentPostEvent;
import com.cobblemon.mod.common.api.events.storage.ReleasePokemonEvent;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.api.types.tera.TeraType;
import com.cobblemon.mod.common.api.types.tera.TeraTypes;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.MiscUtilsKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import me.unariginal.genesisforms.GenesisForms;
import me.unariginal.genesisforms.config.BattleFormChangeConfig;
import me.unariginal.genesisforms.config.EventsConfig;
import me.unariginal.genesisforms.config.MegaEvolutionConfig;
import me.unariginal.genesisforms.handlers.GlowHandler;
import me.unariginal.genesisforms.handlers.PacketHandler;
import me.unariginal.genesisforms.items.helditems.HeldFormItem;
import me.unariginal.genesisforms.items.helditems.Megastone;
import me.unariginal.genesisforms.items.helditems.ZCrystal;
import me.unariginal.genesisforms.items.keyitems.accessories.DynamaxAccessory;
import me.unariginal.genesisforms.items.keyitems.accessories.MegaAccessory;
import me.unariginal.genesisforms.items.keyitems.accessories.TeraAccessory;
import me.unariginal.genesisforms.items.keyitems.accessories.ZAccessory;
import net.minecraft.class_1324;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_5134;

public class CobblemonEventHandler {
    public static Unit battleStartEvent(BattleStartedPreEvent event) {
        PokemonBattle battle = event.getBattle();
        for (class_3222 player : battle.getPlayers()) {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            for (Pokemon pokemon : party) {
                if (pokemon == null) continue;
                CobblemonEventHandler.revertForm(pokemon, false);
            }
            List<class_1799> inventory = CobblemonEventHandler.getValidKeyItemSlots(player);
            boolean hasMega = false;
            boolean hasTera = false;
            boolean hasZ = false;
            boolean hasDmax = false;
            for (class_1799 itemStack : inventory) {
                if (itemStack.method_7909() instanceof MegaAccessory && GenesisForms.INSTANCE.getConfig().enableMegaEvolution) {
                    hasMega = true;
                    continue;
                }
                if (itemStack.method_7909() instanceof TeraAccessory && GenesisForms.INSTANCE.getConfig().enableTera) {
                    if (itemStack.method_7919() == itemStack.method_7936()) continue;
                    hasTera = true;
                    continue;
                }
                if (itemStack.method_7909() instanceof ZAccessory && GenesisForms.INSTANCE.getConfig().enableZCrystals) {
                    hasZ = true;
                    continue;
                }
                if (!(itemStack.method_7909() instanceof DynamaxAccessory) || !GenesisForms.INSTANCE.getConfig().enableDynamax) continue;
                hasDmax = true;
            }
            GeneralPlayerData playerData = Cobblemon.playerDataManager.getGenericData(player);
            playerData.getKeyItems().removeIf(identifier -> identifier.equals((Object)MiscUtilsKt.cobblemonResource((String)"key_stone")) || identifier.equals((Object)MiscUtilsKt.cobblemonResource((String)"tera_orb")) || identifier.equals((Object)MiscUtilsKt.cobblemonResource((String)"z_ring")) || identifier.equals((Object)MiscUtilsKt.cobblemonResource((String)"dynamax_band")));
            if (hasMega) {
                playerData.getKeyItems().add(MiscUtilsKt.cobblemonResource((String)"key_stone"));
            }
            if (hasTera) {
                playerData.getKeyItems().add(MiscUtilsKt.cobblemonResource((String)"tera_orb"));
            }
            if (hasZ) {
                playerData.getKeyItems().add(MiscUtilsKt.cobblemonResource((String)"z_ring"));
            }
            if (!hasDmax || hasTera) continue;
            playerData.getKeyItems().add(MiscUtilsKt.cobblemonResource((String)"dynamax_band"));
        }
        return Unit.INSTANCE;
    }

    public static List<class_1799> getValidKeyItemSlots(class_3222 player) {
        ArrayList<class_1799> inventory = new ArrayList<class_1799>();
        for (class_1799 itemStack : player.method_31548().field_7547) {
            if ((!GenesisForms.INSTANCE.getConfig().useMainInventory || !GenesisForms.INSTANCE.getConfig().useHotbarInventory && class_1661.method_7380((int)player.method_31548().method_7371(itemStack))) && (!GenesisForms.INSTANCE.getConfig().useHotbarInventory || !class_1661.method_7380((int)player.method_31548().method_7371(itemStack)))) continue;
            inventory.add(itemStack);
        }
        if (GenesisForms.INSTANCE.getConfig().useMainHandInventory && !inventory.contains(player.method_6047())) {
            inventory.add(player.method_6047());
        }
        if (GenesisForms.INSTANCE.getConfig().useOffHandInventory && !inventory.contains(player.method_6079())) {
            inventory.add(player.method_6079());
        }
        if (GenesisForms.INSTANCE.getConfig().useArmorInventory) {
            for (class_1799 itemStack : player.method_5661()) {
                if (inventory.contains(itemStack)) continue;
                inventory.add(itemStack);
            }
        }
        Iterator<Object> iterator = GenesisForms.INSTANCE.getConfig().specificSlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            class_1799 stack = player.method_31548().method_5438(slot);
            if (inventory.contains(stack)) continue;
            inventory.add(stack);
        }
        return inventory;
    }

    public static Unit battleEndEvent(BattleVictoryEvent event) {
        PokemonBattle battle = event.getBattle();
        for (class_3222 player : battle.getPlayers()) {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            for (Pokemon pokemon : party) {
                if (pokemon == null) continue;
                CobblemonEventHandler.revertForm(pokemon, false);
            }
        }
        return Unit.INSTANCE;
    }

    public static Unit battleFledEvent(BattleFledEvent event) {
        PokemonBattle battle = event.getBattle();
        for (class_3222 player : battle.getPlayers()) {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            for (Pokemon pokemon : party) {
                if (pokemon == null) continue;
                CobblemonEventHandler.revertForm(pokemon, false);
            }
        }
        return Unit.INSTANCE;
    }

    public static Unit battleFaintEvent(BattleFaintedEvent event) {
        Pokemon pokemon = event.getKilled().getEffectedPokemon();
        if (pokemon.isPlayerOwned()) {
            CobblemonEventHandler.revertForm(pokemon, true);
        }
        return Unit.INSTANCE;
    }

    public static Unit formChangeEvent(FormeChangeEvent event) {
        String formName = event.getFormeName();
        BattlePokemon battlePokemon = event.getPokemon();
        Pokemon pokemon = battlePokemon.getEffectedPokemon();
        PokemonBattle battle = event.getBattle();
        if (pokemon.getSpecies().getName().equalsIgnoreCase("zygarde") && formName.equalsIgnoreCase("complete")) {
            if (pokemon.getAspects().contains("10-percent")) {
                pokemon.getPersistentData().method_10582("percent_cells", "10");
            } else {
                pokemon.getPersistentData().method_10582("percent_cells", "50");
            }
            new StringSpeciesFeature("percent_cells", "complete").apply(pokemon);
        }
        for (BattleFormChangeConfig.BattleFormInformation battleFormInformation : BattleFormChangeConfig.battleForms.values()) {
            if (!battleFormInformation.species.equalsIgnoreCase(pokemon.getSpecies().showdownId()) || !battleFormInformation.forms.containsKey(formName)) continue;
            if (battleFormInformation.forms.get((Object)formName).featureValue.equalsIgnoreCase("true") || battleFormInformation.forms.get((Object)formName).featureValue.equalsIgnoreCase("false")) {
                new FlagSpeciesFeature(battleFormInformation.forms.get((Object)formName).featureName, Boolean.getBoolean(battleFormInformation.forms.get((Object)formName).featureValue)).apply(pokemon);
                break;
            }
            new StringSpeciesFeature(battleFormInformation.forms.get((Object)formName).featureName, battleFormInformation.forms.get((Object)formName).featureValue).apply(pokemon);
            break;
        }
        PacketHandler.updatePackets(battle, battlePokemon, false);
        return Unit.INSTANCE;
    }

    public static void revertForm(Pokemon pokemon, boolean fromBattle) {
        AbilityTemplate abilityTemplate;
        boolean ultra;
        class_1324 scaleAttribute;
        PokemonEntity pokemonEntity;
        class_1792 heldItem = pokemon.heldItem().method_7909();
        if (heldItem instanceof Megastone) {
            Megastone megastone = (Megastone)heldItem;
            if (CobblemonEventHandler.revertMega(pokemon, megastone.getMegastoneData().featureName)) {
                EventsConfig.gimmickEvents.megaEvolution.revertEvent(megastone.getItemID(), pokemon, pokemon.getEntity());
            }
        } else {
            for (String string : MegaEvolutionConfig.itemlessMegas) {
                MegaEvolutionConfig.MegaEvolutionData megaEvolutionData = MegaEvolutionConfig.megaEvolutionMap.get(string);
                if (megaEvolutionData == null || !megaEvolutionData.canMegaEvolve(pokemon) || !CobblemonEventHandler.revertMega(pokemon, megaEvolutionData.featureName)) continue;
                EventsConfig.gimmickEvents.megaEvolution.revertEvent(string, pokemon, pokemon.getEntity());
            }
            if (heldItem instanceof ZCrystal) {
                ZCrystal zcrystal = (ZCrystal)heldItem;
                EventsConfig.gimmickEvents.zPower.revertEvent(zcrystal.getItemID(), pokemon, pokemon.getEntity());
            }
        }
        if (pokemon.getFeatures().removeIf(speciesFeature -> speciesFeature.getName().equalsIgnoreCase("dynamax_form")) && (pokemonEntity = pokemon.getEntity()) != null && (scaleAttribute = pokemonEntity.method_5996(class_5134.field_47760)) != null) {
            scaleAttribute.method_6192(1.0);
        }
        if (ultra = pokemon.getFeatures().stream().anyMatch(speciesFeature -> {
            if (speciesFeature.getName().equalsIgnoreCase("prism_fusion") && speciesFeature instanceof StringSpeciesFeature) {
                StringSpeciesFeature stringSpeciesFeature = (StringSpeciesFeature)speciesFeature;
                return stringSpeciesFeature.getValue().equalsIgnoreCase("ultra");
            }
            return false;
        })) {
            new StringSpeciesFeature("prism_fusion", pokemon.getPersistentData().method_10558("prism_fusion")).apply(pokemon);
            pokemon.getPersistentData().method_10551("prism_fusion");
        }
        boolean wasComplete = false;
        if (pokemon.getSpecies().getName().equalsIgnoreCase("zygarde") && pokemon.getFeatures().stream().anyMatch(speciesFeature -> {
            if (speciesFeature.getName().equalsIgnoreCase("percent_cells") && speciesFeature instanceof StringSpeciesFeature) {
                StringSpeciesFeature stringSpeciesFeature = (StringSpeciesFeature)speciesFeature;
                return stringSpeciesFeature.getValue().equalsIgnoreCase("complete");
            }
            return false;
        })) {
            if (pokemon.getPersistentData().method_10545("percent_cells")) {
                new StringSpeciesFeature("percent_cells", pokemon.getPersistentData().method_10558("percent_cells")).apply(pokemon);
            } else {
                new StringSpeciesFeature("percent_cells", "50").apply(pokemon);
            }
            wasComplete = true;
        }
        if (!fromBattle) {
            for (BattleFormChangeConfig.BattleFormInformation battleFormInformation : BattleFormChangeConfig.battleForms.values()) {
                if (!battleFormInformation.species.equalsIgnoreCase(pokemon.getSpecies().getName()) || pokemon.getSpecies().getName().equals("Greninja") && !pokemon.getAspects().contains("ash")) continue;
                if (battleFormInformation.defaultForm.featureValue.equalsIgnoreCase("true") || battleFormInformation.defaultForm.featureValue.equalsIgnoreCase("false")) {
                    new FlagSpeciesFeature(battleFormInformation.defaultForm.featureName, Boolean.getBoolean(battleFormInformation.defaultForm.featureValue)).apply(pokemon);
                    continue;
                }
                new StringSpeciesFeature(battleFormInformation.defaultForm.featureName, battleFormInformation.defaultForm.featureValue).apply(pokemon);
            }
            if (pokemon.getSpecies().getName().equals("Ogerpon")) {
                new FlagSpeciesFeature("embody_aspect", false).apply(pokemon);
            }
        }
        if (pokemon.getPersistentData().method_10545("tera_type")) {
            String string = pokemon.getPersistentData().method_10558("tera_type");
            pokemon.getPersistentData().method_10551("tera_type");
            EventsConfig.gimmickEvents.terastallization.revertEvent(string, pokemon, pokemon.getEntity());
        }
        pokemon.updateAspects();
        pokemon.updateForm();
        if (wasComplete && (abilityTemplate = Abilities.INSTANCE.get("powerconstruct")) != null) {
            pokemon.setAbility$common(abilityTemplate.create(false, Priority.LOW));
        }
    }

    public static Unit pokemonSentEvent(PokemonSentPostEvent event) {
        if (event.getPokemon().getPersistentData().method_10545("glow_id") && event.getPokemon().getPersistentData().method_10545("glow_color")) {
            String glowID = event.getPokemon().getPersistentData().method_10558("glow_id");
            String glowColor = event.getPokemon().getPersistentData().method_10558("glow_color");
            GlowHandler.applyGlowing(glowID, glowColor, event.getPokemon(), event.getPokemonEntity());
        }
        return Unit.INSTANCE;
    }

    public static Unit heldItemChange(HeldItemEvent.Post event) {
        class_1799 received = event.getReceived();
        class_1799 returned = event.getReturned();
        Pokemon pokemon = event.getPokemon();
        if (received == returned) {
            return Unit.INSTANCE;
        }
        CobblemonEventHandler.revertFormByItem(pokemon, returned.method_7909());
        class_1792 class_17922 = received.method_7909();
        if (class_17922 instanceof ZCrystal) {
            ZCrystal zCrystal = (ZCrystal)class_17922;
            GenesisForms.INSTANCE.logError("[Genesis] This is a Z Crystal!");
            zCrystal.getFormChanges().forEach(formChange -> {
                boolean speciesMatch = false;
                for (String species : formChange.species) {
                    if (!pokemon.getSpecies().getName().equalsIgnoreCase(species)) continue;
                    speciesMatch = true;
                    break;
                }
                if (speciesMatch) {
                    GenesisForms.INSTANCE.logError("[Genesis] Species match! Name: " + formChange.featureName + " Value: " + formChange.alternateValue);
                    if (formChange.alternateValue.equalsIgnoreCase("true") || formChange.alternateValue.equalsIgnoreCase("false")) {
                        new FlagSpeciesFeature(formChange.featureName, Boolean.getBoolean(formChange.alternateValue)).apply(pokemon);
                    } else {
                        new StringSpeciesFeature(formChange.featureName, formChange.alternateValue).apply(pokemon);
                    }
                    pokemon.updateAspects();
                    pokemon.updateForm();
                }
            });
        }
        if ((class_17922 = received.method_7909()) instanceof HeldFormItem) {
            HeldFormItem heldFormItem = (HeldFormItem)class_17922;
            GenesisForms.INSTANCE.logError("[Genesis] This is a Held Form Item!");
            if (heldFormItem.getSpeciesList().contains(pokemon.getSpecies())) {
                GenesisForms.INSTANCE.logError("[Genesis] Species match! Name: " + heldFormItem.getFormData().featureName + " Value: " + heldFormItem.getFormData().alternateValue);
                if (heldFormItem.getFormData().alternateValue.equalsIgnoreCase("true") || heldFormItem.getFormData().alternateValue.equalsIgnoreCase("false")) {
                    new FlagSpeciesFeature(heldFormItem.getFormData().featureName, Boolean.getBoolean(heldFormItem.getFormData().alternateValue)).apply(pokemon);
                } else {
                    new StringSpeciesFeature(heldFormItem.getFormData().featureName, heldFormItem.getFormData().alternateValue).apply(pokemon);
                }
                CobblemonEventHandler.fixOgerponTeraType(pokemon, heldFormItem.getShowdownID());
                pokemon.updateAspects();
                pokemon.updateForm();
            }
        }
        return Unit.INSTANCE;
    }

    public static void fixOgerponTeraType(Pokemon pokemon, String showdownID) {
        if (GenesisForms.INSTANCE.getConfig().fixOgerponTeraType && pokemon.getSpecies().getName().equalsIgnoreCase("ogerpon")) {
            switch (showdownID) {
                case "hearthflamemask": {
                    pokemon.setTeraType(TeraTypes.getFIRE());
                    break;
                }
                case "wellspringmask": {
                    pokemon.setTeraType(TeraTypes.getWATER());
                    break;
                }
                case "cornerstonemask": {
                    pokemon.setTeraType(TeraTypes.getROCK());
                    break;
                }
                default: {
                    pokemon.setTeraType(TeraTypes.getGRASS());
                }
            }
        }
    }

    public static void revertFormByItem(Pokemon pokemon, class_1792 item) {
        HeldFormItem heldFormItem;
        if (item instanceof Megastone) {
            Megastone megastone = (Megastone)item;
            if (pokemon.getAspects().stream().anyMatch(aspect -> aspect.startsWith("mega"))) {
                CobblemonEventHandler.revertMega(pokemon, megastone.getMegastoneData().featureName);
            }
        }
        if (item instanceof ZCrystal) {
            ZCrystal zcrystal = (ZCrystal)item;
            zcrystal.getFormChanges().forEach(formChange -> {
                boolean speciesMatch = false;
                for (String species : formChange.species) {
                    if (!pokemon.getSpecies().getName().equalsIgnoreCase(species)) continue;
                    speciesMatch = true;
                    break;
                }
                if (speciesMatch) {
                    pokemon.getFeatures().removeIf(feature -> feature.getName().equalsIgnoreCase(formChange.featureName));
                    if (formChange.defaultValue.equalsIgnoreCase("true") || formChange.defaultValue.equalsIgnoreCase("false")) {
                        new FlagSpeciesFeature(formChange.featureName, Boolean.getBoolean(formChange.defaultValue)).apply(pokemon);
                    } else {
                        new StringSpeciesFeature(formChange.featureName, formChange.defaultValue).apply(pokemon);
                    }
                    pokemon.updateAspects();
                    pokemon.updateForm();
                }
            });
        }
        if (item instanceof HeldFormItem && (heldFormItem = (HeldFormItem)item).getSpeciesList().contains(pokemon.getSpecies())) {
            pokemon.getFeatures().removeIf(feature -> feature.getName().equalsIgnoreCase(heldFormItem.getFormData().featureName));
            if (heldFormItem.getFormData().defaultValue.equalsIgnoreCase("true") || heldFormItem.getFormData().defaultValue.equalsIgnoreCase("false")) {
                new FlagSpeciesFeature(heldFormItem.getFormData().featureName, Boolean.getBoolean(heldFormItem.getFormData().defaultValue)).apply(pokemon);
            } else {
                new StringSpeciesFeature(heldFormItem.getFormData().featureName, heldFormItem.getFormData().defaultValue).apply(pokemon);
            }
            pokemon.updateAspects();
            pokemon.updateForm();
        }
    }

    public static Unit megaEvolveEvent(MegaEvolutionEvent event) {
        PokemonBattle battle = event.getBattle();
        BattlePokemon battlePokemon = event.getPokemon();
        Pokemon pokemon = battlePokemon.getEffectedPokemon();
        CobblemonEventHandler.megaEvolveLogic(pokemon);
        PacketHandler.updatePackets(battle, battlePokemon, true);
        return Unit.INSTANCE;
    }

    public static void megaEvolveLogic(Pokemon pokemon) {
        class_1792 heldItem = pokemon.heldItem().method_7909();
        boolean canMegaEvolve = false;
        String featureName = "mega_evolution";
        String featureValue = "mega";
        String eventID = "global";
        if (heldItem instanceof Megastone) {
            Megastone megastone = (Megastone)heldItem;
            if (megastone.getMegastoneData().canMegaEvolve(pokemon)) {
                canMegaEvolve = true;
                featureName = megastone.getMegastoneData().featureName;
                featureValue = megastone.getMegastoneData().featureValue;
                eventID = megastone.getItemID();
            }
        } else {
            for (String itemlessMega : MegaEvolutionConfig.itemlessMegas) {
                MegaEvolutionConfig.MegaEvolutionData megaEvolutionData = MegaEvolutionConfig.megaEvolutionMap.get(itemlessMega);
                if (megaEvolutionData == null || !megaEvolutionData.canMegaEvolve(pokemon)) continue;
                canMegaEvolve = true;
                featureName = megaEvolutionData.featureName;
                featureValue = megaEvolutionData.featureValue;
                eventID = itemlessMega;
            }
        }
        EventsConfig.AnimationData megaAnimation = EventsConfig.gimmickEvents.megaEvolution.getAnimation(eventID);
        if (canMegaEvolve) {
            EventsConfig.gimmickEvents.megaEvolution.runEvent(eventID, pokemon, pokemon.getEntity());
            if (pokemon.getEntity() != null && megaAnimation != null) {
                String finalFeatureValue = featureValue;
                String finalFeatureName = featureName;
                pokemon.getEntity().after(megaAnimation.formDelaySeconds, () -> {
                    if (pokemon.getOwnerUUID() == null || GenesisForms.INSTANCE.getPlayersWithMega().containsKey(pokemon.getOwnerUUID())) {
                        return Unit.INSTANCE;
                    }
                    if (finalFeatureValue.equalsIgnoreCase("true") || finalFeatureValue.equalsIgnoreCase("false")) {
                        new FlagSpeciesFeature(finalFeatureName, Boolean.getBoolean(finalFeatureValue)).apply(pokemon);
                    } else {
                        new StringSpeciesFeature(finalFeatureName, finalFeatureValue).apply(pokemon);
                    }
                    if (pokemon.isPlayerOwned() && pokemon.getOwnerUUID() != null) {
                        GenesisForms.INSTANCE.getPlayersWithMega().put(pokemon.getOwnerUUID(), pokemon.getUuid());
                    }
                    return Unit.INSTANCE;
                });
            } else {
                if (pokemon.getOwnerUUID() == null || GenesisForms.INSTANCE.getPlayersWithMega().containsKey(pokemon.getOwnerUUID())) {
                    return;
                }
                if (featureValue.equalsIgnoreCase("true") || featureValue.equalsIgnoreCase("false")) {
                    new FlagSpeciesFeature(featureName, Boolean.getBoolean(featureValue)).apply(pokemon);
                } else {
                    new StringSpeciesFeature(featureName, featureValue).apply(pokemon);
                }
                if (pokemon.isPlayerOwned() && pokemon.getOwnerUUID() != null) {
                    GenesisForms.INSTANCE.getPlayersWithMega().put(pokemon.getOwnerUUID(), pokemon.getUuid());
                }
            }
            if (pokemon.getTradeable() || GenesisForms.INSTANCE.getConfig().alwaysModifyTradeableProperty) {
                pokemon.getPersistentData().method_10556("genesis_untradeable", true);
                pokemon.setTradeable(false);
            }
        }
    }

    public static boolean revertMega(Pokemon pokemon, String featureName) {
        boolean wasMega = pokemon.getFeatures().removeIf(features -> features.getName().equalsIgnoreCase(featureName));
        if (wasMega && (pokemon.getPersistentData().method_10545("genesis_untradeable") || GenesisForms.INSTANCE.getConfig().alwaysModifyTradeableProperty)) {
            pokemon.setTradeable(true);
            pokemon.getPersistentData().method_10551("genesis_untradeable");
        }
        if (wasMega && pokemon.getOwnerUUID() != null) {
            GenesisForms.INSTANCE.getPlayersWithMega().remove(pokemon.getOwnerUUID());
        }
        pokemon.updateAspects();
        pokemon.updateForm();
        return wasMega;
    }

    public static Unit pokemonReleasedEvent(ReleasePokemonEvent.Post event) {
        class_3222 player = event.getPlayer();
        Pokemon pokemon = event.getPokemon();
        if (GenesisForms.INSTANCE.getPlayersWithMega().containsKey(player.method_5667()) && pokemon.getUuid().equals(GenesisForms.INSTANCE.getPlayersWithMega().get(player.method_5667()))) {
            GenesisForms.INSTANCE.getPlayersWithMega().remove(player.method_5667());
        }
        return Unit.INSTANCE;
    }

    public static Unit pokemonGainedEvent(PokemonGainedEvent event) {
        if (event.getPokemon().getSpecies().getName().equalsIgnoreCase("Terapagos") && GenesisForms.INSTANCE.getConfig().fixTerapagosTeraType) {
            event.getPokemon().setTeraType(TeraTypes.getSTELLAR());
        }
        if (event.getPokemon().getSpecies().getName().equalsIgnoreCase("Ogerpon") && GenesisForms.INSTANCE.getConfig().fixOgerponTeraType) {
            for (SpeciesFeature speciesFeature : event.getPokemon().getFeatures()) {
                if (!speciesFeature.getName().equalsIgnoreCase("ogre_mask") || !(speciesFeature instanceof StringSpeciesFeature)) continue;
                StringSpeciesFeature stringSpeciesFeature = (StringSpeciesFeature)speciesFeature;
                switch (stringSpeciesFeature.getValue()) {
                    case "cornerstone": {
                        event.getPokemon().setTeraType(TeraTypes.getROCK());
                        break;
                    }
                    case "hearthflame": {
                        event.getPokemon().setTeraType(TeraTypes.getFIRE());
                        break;
                    }
                    case "wellspring": {
                        event.getPokemon().setTeraType(TeraTypes.getWATER());
                        break;
                    }
                    default: {
                        event.getPokemon().setTeraType(TeraTypes.getGRASS());
                        break;
                    }
                }
                break;
            }
        }
        return Unit.INSTANCE;
    }

    public static Unit terastallizationEvent(TerastallizationEvent event) {
        BattlePokemon battlePokemon = event.getPokemon();
        Pokemon pokemon = battlePokemon.getEffectedPokemon();
        PokemonEntity pokemonEntity = battlePokemon.getEntity();
        TeraType teraType = event.getTeraType();
        pokemon.getPersistentData().method_10582("tera_type", teraType.showdownId());
        if (pokemon.getSpecies().getName().equalsIgnoreCase("Terapagos")) {
            new StringSpeciesFeature("tera_form", "stellar").apply(pokemon);
        }
        if (pokemon.getSpecies().getName().equalsIgnoreCase("Ogerpon")) {
            new FlagSpeciesFeature("embody_aspect", true).apply(pokemon);
        }
        if (pokemonEntity != null) {
            EventsConfig.gimmickEvents.terastallization.runEvent(teraType.showdownId(), pokemon, pokemonEntity);
        }
        if (pokemon.isPlayerOwned() && pokemon.getOwnerPlayer() != null) {
            for (class_1799 stack : CobblemonEventHandler.getValidKeyItemSlots(pokemon.getOwnerPlayer())) {
                class_1792 class_17922 = stack.method_7909();
                if (!(class_17922 instanceof TeraAccessory)) continue;
                TeraAccessory teraAccessory = (TeraAccessory)class_17922;
                if (!teraAccessory.requiresCharge || !GenesisForms.INSTANCE.getConfig().requireOrbRecharge) continue;
                stack.method_7974(stack.method_7936());
            }
        }
        return Unit.INSTANCE;
    }

    public static Unit zPowerEvent(ZMoveUsedEvent event) {
        Pokemon pokemon = event.getPokemon().getEffectedPokemon();
        PokemonEntity pokemonEntity = event.getPokemon().getEntity();
        class_1792 heldItem = pokemon.heldItem().method_7909();
        if (heldItem instanceof ZCrystal) {
            ZCrystal zCrystal = (ZCrystal)heldItem;
            EventsConfig.gimmickEvents.zPower.runEvent(zCrystal.getItemID(), pokemon, pokemonEntity);
        }
        return Unit.INSTANCE;
    }
}

