/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.genesisforms.items.bagitems;

import com.cobblemon.mod.common.CobblemonSounds;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.PokemonInteractContext;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BagItemActionResponse;
import com.cobblemon.mod.common.battles.BattleRegistry;
import com.cobblemon.mod.common.battles.ShowdownActionResponse;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.item.battle.SimpleBagItemLike;
import com.cobblemon.mod.common.util.LocalizationUtilsKt;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import java.util.List;
import me.unariginal.genesisforms.GenesisForms;
import me.unariginal.genesisforms.items.BasePolymerBlockItem;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaxMushrooms
extends BasePolymerBlockItem
implements SimpleBagItemLike {
    private final boolean consumable;
    public BagItem bagItem = new BagItem(this){

        public boolean canStillUse(@NotNull class_3222 serverPlayerEntity, @NotNull PokemonBattle pokemonBattle, @NotNull BattleActor battleActor, @NotNull BattlePokemon battlePokemon, @NotNull class_1799 itemStack) {
            return false;
        }

        @NotNull
        public String getItemName() {
            return "max_mushrooms";
        }

        @NotNull
        public class_1792 getReturnItem() {
            return class_1802.field_8162;
        }

        public boolean canUse(@NotNull PokemonBattle battle, @NotNull BattlePokemon target) {
            return target.getHealth() > 0;
        }

        @NotNull
        public String getShowdownInput(@NotNull BattleActor battleActor, @NotNull BattlePokemon battlePokemon, @Nullable String s) {
            return "max_mushroom";
        }
    };

    public MaxMushrooms(class_2248 block, class_1792.class_1793 settings, PolymerModelData modelData, List<String> lore, boolean consumable) {
        super(block, settings, modelData, "max_mushrooms", lore);
        this.consumable = consumable;
    }

    @NotNull
    public BagItem getBagItem() {
        return this.bagItem;
    }

    @Nullable
    public BagItem getBagItem(@NotNull class_1799 itemStack) {
        return this.bagItem;
    }

    public boolean handleInteraction(@NotNull class_3222 serverPlayerEntity, @NotNull BattlePokemon battlePokemon, @NotNull class_1799 itemStack) {
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        BattleActor actor;
        PokemonBattle battle;
        if (GenesisForms.INSTANCE.getConfig().disabledItems.contains("max_mushrooms")) {
            return class_1271.method_22427((Object)user.method_5998(hand));
        }
        class_3222 player = GenesisForms.INSTANCE.getServer().method_3760().method_14602(user.method_5667());
        class_1799 stack = user.method_5998(hand);
        if (player != null && (battle = BattleRegistry.INSTANCE.getBattleByParticipatingPlayer(player)) != null && (actor = battle.getActor(player)) != null) {
            ActiveBattlePokemon activeBattlePokemon = (ActiveBattlePokemon)actor.getActivePokemon().getFirst();
            BattlePokemon battlePokemon = null;
            if (activeBattlePokemon != null) {
                battlePokemon = activeBattlePokemon.getBattlePokemon();
            }
            if (battlePokemon == null) {
                return class_1271.method_22428((Object)stack);
            }
            if (!actor.canFitForcedAction()) {
                player.method_43502((class_2561)LocalizationUtilsKt.battleLang((String)"bagitem.cannot", (Object[])new Object[0]).method_27694(style -> style.method_10977(class_124.field_1061)), true);
                return class_1271.method_22428((Object)stack);
            }
            try {
                int turn = battle.getTurn();
                if (this.bagItem.canUse(battle, battlePokemon) && actor.canFitForcedAction() && battlePokemon.getHealth() > 0 && battle.getTurn() == turn) {
                    player.method_5783(CobblemonSounds.ITEM_USE, 1.0f, 1.0f);
                    actor.forceChoose((ShowdownActionResponse)new BagItemActionResponse(this.bagItem, battlePokemon, battlePokemon.getUuid().toString()));
                    class_2960 stackName = class_7923.field_41178.method_10221((Object)stack.method_7909());
                    if (this.consumable) {
                        stack.method_57008(1, (class_1309)player);
                    }
                    CobblemonCriteria.INSTANCE.getPOKEMON_INTERACT().trigger(player, (Object)new PokemonInteractContext(battlePokemon.getEffectedPokemon().getSpecies().getResourceIdentifier(), stackName));
                }
            }
            catch (NoSuchMethodError e) {
                GenesisForms.INSTANCE.logError("[Genesis] Suppressing NoSuchMethodError! " + e.getMessage());
            }
        }
        return class_1271.method_22427((Object)stack);
    }
}

