/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.genesisforms.items.keyitems;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.item.PokemonSelectingItem;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonPropertyExtractor;
import com.cobblemon.mod.common.api.pokemon.feature.FlagSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.IntSpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.SpeciesFeature;
import com.cobblemon.mod.common.api.pokemon.feature.StringSpeciesFeature;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import eu.pb4.polymer.resourcepack.api.PolymerModelData;
import java.util.List;
import me.unariginal.genesisforms.GenesisForms;
import me.unariginal.genesisforms.config.items.keyitems.FusionItemsConfig;
import me.unariginal.genesisforms.items.ConsumablePolymerItem;
import me.unariginal.genesisforms.utils.PokemonUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FusionItem
extends ConsumablePolymerItem
implements PokemonSelectingItem {
    private final List<FusionItemsConfig.FusionData> fusions;

    public FusionItem(class_1792.class_1793 settings, class_1792 polymerItem, PolymerModelData modelData, String itemID, List<String> lore, boolean consumable, List<FusionItemsConfig.FusionData> fusions) {
        super(settings, polymerItem, modelData, itemID, lore, consumable);
        this.fusions = fusions;
    }

    @Nullable
    public BagItem getBagItem() {
        return null;
    }

    public boolean canUseOnPokemon(@NotNull Pokemon pokemon) {
        for (FusionItemsConfig.FusionData fusionData : this.fusions) {
            if (!pokemon.getSpecies().getName().equalsIgnoreCase(fusionData.corePokemon)) continue;
            return true;
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            return this.use(player, player.method_5998(hand));
        }
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    @Nullable
    public class_1271<class_1799> applyToPokemon(@NotNull class_3222 serverPlayerEntity, @NotNull class_1799 itemStack, @NotNull Pokemon pokemon) {
        if (!this.canUseOnPokemon(pokemon)) {
            return class_1271.method_22431((Object)itemStack);
        }
        if (GenesisForms.INSTANCE.getConfig().disabledItems.contains(this.itemID) || !GenesisForms.INSTANCE.getConfig().enableFusions) {
            return class_1271.method_22431((Object)itemStack);
        }
        PlayerPartyStore partyStore = Cobblemon.INSTANCE.getStorage().getParty(serverPlayerEntity);
        boolean isFused = false;
        FusionItemsConfig.FuelPokemonData fusedFuelPokemonData = null;
        block0: for (FusionItemsConfig.FusionData fusionData : this.fusions) {
            if (!pokemon.getSpecies().getName().equalsIgnoreCase(fusionData.corePokemon)) continue;
            for (FusionItemsConfig.FuelPokemonData fuelPokemonData : fusionData.fuelPokemon) {
                if (!pokemon.getFeatures().stream().anyMatch(speciesFeature -> {
                    if (speciesFeature.getName().equalsIgnoreCase(fuelPokemonData.resultFeatureName) && speciesFeature instanceof StringSpeciesFeature) {
                        StringSpeciesFeature stringSpeciesFeature = (StringSpeciesFeature)speciesFeature;
                        return stringSpeciesFeature.getValue().equalsIgnoreCase(fuelPokemonData.resultFeatureValue);
                    }
                    return false;
                })) continue;
                isFused = true;
                fusedFuelPokemonData = fuelPokemonData;
                continue block0;
            }
        }
        if (isFused) {
            PokemonProperties properties;
            class_2487 persistenData = pokemon.getPersistentData();
            boolean oldData = false;
            if (persistenData.method_10545("fusion_data") && persistenData.method_10562("fusion_data").method_10545("fuel_properties")) {
                class_2487 fusionData = persistenData.method_10562("fusion_data");
                class_2487 fuelProperties = fusionData.method_10562("fuel_properties");
                properties = PokemonUtils.loadFromNBT(fuelProperties);
            } else {
                oldData = true;
                properties = PokemonUtils.loadFromNBT(pokemon.getPersistentData());
            }
            properties.setSpecies(fusedFuelPokemonData.species);
            FusionItemsConfig.FuelPokemonData finalFusedFuelPokemonData = fusedFuelPokemonData;
            pokemon.getFeatures().removeIf(feature -> feature.getName().equalsIgnoreCase(finalFusedFuelPokemonData.resultFeatureName));
            pokemon.updateAspects();
            pokemon.updateForm();
            Pokemon returnedPokemon = properties.create();
            if (!oldData && persistenData.method_10562("fusion_data").method_10545("fuel_features")) {
                class_2487 fusionData = persistenData.method_10562("fusion_data");
                class_2487 fuelFeatures = fusionData.method_10562("fuel_features");
                for (String featureName : fuelFeatures.method_10541()) {
                    class_2520 featureValue = fuelFeatures.method_10580(featureName);
                    if (featureValue instanceof class_2519) {
                        class_2519 value = (class_2519)featureValue;
                        new StringSpeciesFeature(featureName, value.method_10714()).apply(returnedPokemon);
                        continue;
                    }
                    if (featureValue instanceof class_2481) {
                        class_2481 value = (class_2481)featureValue;
                        new FlagSpeciesFeature(featureName, value.method_10698() == 1).apply(returnedPokemon);
                        continue;
                    }
                    if (!(featureValue instanceof class_2497)) continue;
                    class_2497 value = (class_2497)featureValue;
                    new IntSpeciesFeature(featureName, value.method_10701()).apply(returnedPokemon);
                }
            }
            if (!oldData) {
                persistenData.method_10551("fusion_data");
                pokemon.setPersistentData$common(persistenData);
            }
            if (oldData) {
                IntSpeciesFeature dynamaxLevelFeature = (IntSpeciesFeature)returnedPokemon.getFeature("dynamax_level");
                assert (dynamaxLevelFeature != null);
                dynamaxLevelFeature.setValue(returnedPokemon.getDmaxLevel());
                returnedPokemon.markFeatureDirty((SpeciesFeature)dynamaxLevelFeature);
            }
            partyStore.add(returnedPokemon);
            if (this.consumable) {
                itemStack.method_57008(1, (class_1309)serverPlayerEntity);
            }
        } else {
            FusionItemsConfig.FusionData fusion = null;
            for (FusionItemsConfig.FusionData fusionData : this.fusions) {
                if (!pokemon.getSpecies().getName().equalsIgnoreCase(fusionData.corePokemon)) continue;
                fusion = fusionData;
            }
            if (fusion == null) {
                return class_1271.method_22431((Object)itemStack);
            }
            block4: for (Pokemon partyPokemon : partyStore) {
                if (partyPokemon == null) continue;
                for (FusionItemsConfig.FuelPokemonData fuelPokemon : fusion.fuelPokemon) {
                    if (!partyPokemon.getSpecies().getName().equalsIgnoreCase(fuelPokemon.species)) continue;
                    if (fuelPokemon.resultFeatureValue.equalsIgnoreCase("true") || fuelPokemon.resultFeatureValue.equalsIgnoreCase("false")) {
                        new FlagSpeciesFeature(fuelPokemon.resultFeatureName, Boolean.getBoolean(fuelPokemon.resultFeatureValue)).apply(pokemon);
                    } else {
                        new StringSpeciesFeature(fuelPokemon.resultFeatureName, fuelPokemon.resultFeatureValue).apply(pokemon);
                    }
                    class_2487 persistentData = pokemon.getPersistentData();
                    class_2487 fusionData = new class_2487();
                    fusionData.method_10566("fuel_properties", (class_2520)PokemonUtils.saveToNBT(partyPokemon.createPokemonProperties(PokemonPropertyExtractor.ALL)));
                    class_2487 speciesFeatures = new class_2487();
                    for (SpeciesFeature speciesFeature2 : partyPokemon.getFeatures()) {
                        speciesFeatures = speciesFeature2.saveToNBT(speciesFeatures);
                    }
                    fusionData.method_10566("fuel_features", (class_2520)speciesFeatures);
                    persistentData.method_10566("fusion_data", (class_2520)fusionData);
                    pokemon.setPersistentData$common(persistentData);
                    partyStore.remove(partyPokemon);
                    pokemon.updateAspects();
                    pokemon.updateForm();
                    if (!this.consumable) break block4;
                    itemStack.method_57008(1, (class_1309)serverPlayerEntity);
                    break block4;
                }
            }
        }
        return class_1271.method_22427((Object)itemStack);
    }

    @NotNull
    public class_1271<class_1799> use(@NotNull class_3222 serverPlayerEntity, @NotNull class_1799 itemStack) {
        return PokemonSelectingItem.DefaultImpls.use((PokemonSelectingItem)this, (class_3222)serverPlayerEntity, (class_1799)itemStack);
    }

    public void applyToBattlePokemon(@NotNull class_3222 serverPlayerEntity, @NotNull class_1799 itemStack, @NotNull BattlePokemon battlePokemon) {
    }

    public boolean canUseOnBattlePokemon(@NotNull BattlePokemon battlePokemon) {
        return false;
    }

    @NotNull
    public class_1271<class_1799> interactWithSpecificBattle(@NotNull class_3222 serverPlayerEntity, @NotNull class_1799 itemStack, @NotNull BattlePokemon battlePokemon) {
        return class_1271.method_22431((Object)itemStack);
    }

    @NotNull
    public class_1271<class_1799> interactGeneral(@NotNull class_3222 serverPlayerEntity, @NotNull class_1799 itemStack) {
        return PokemonSelectingItem.DefaultImpls.interactGeneral((PokemonSelectingItem)this, (class_3222)serverPlayerEntity, (class_1799)itemStack);
    }

    @NotNull
    public class_1271<class_1799> interactGeneralBattle(@NotNull class_3222 serverPlayerEntity, @NotNull class_1799 itemStack, @NotNull BattleActor battleActor) {
        return class_1271.method_22431((Object)itemStack);
    }
}

