/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.genesisforms.mixin;

import com.cobblemon.mod.common.battles.ActiveBattlePokemon;
import com.cobblemon.mod.common.battles.BattleTypes;
import com.cobblemon.mod.common.battles.InBattleGimmickMove;
import com.cobblemon.mod.common.battles.InBattleMove;
import com.cobblemon.mod.common.battles.MoveActionResponse;
import com.cobblemon.mod.common.battles.MoveTarget;
import com.cobblemon.mod.common.battles.ShowdownMoveset;
import java.util.List;
import kotlin.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={MoveActionResponse.class}, remap=false)
public abstract class MoveActionResponseMixin {
    @Shadow
    private String moveName;
    @Shadow
    private String targetPnx;
    @Shadow
    private String gimmickID;

    @Overwrite
    public boolean isValid(ActiveBattlePokemon activeBattlePokemon, ShowdownMoveset showdownMoveSet, boolean forceSwitch) {
        boolean isMultitargetGimmickInSingles;
        boolean validGimmickMove;
        if (forceSwitch || showdownMoveSet == null) {
            return false;
        }
        InBattleMove move = showdownMoveSet.getMoves().stream().filter(inBattleMove -> inBattleMove.getId().equals(this.moveName)).findFirst().orElse(null);
        if (move == null) {
            return false;
        }
        InBattleGimmickMove gimmickMove = move.getGimmickMove();
        boolean bl = validGimmickMove = gimmickMove != null && !gimmickMove.getDisabled();
        if (!validGimmickMove && !move.canBeUsed()) {
            return false;
        }
        MoveTarget moveTarget = this.gimmickID != null && gimmickMove != null ? gimmickMove.getTarget() : move.getTarget();
        List availableTargets = (List)moveTarget.getTargetList().invoke((Object)activeBattlePokemon);
        if (availableTargets == null || availableTargets.isEmpty()) {
            return true;
        }
        boolean bl2 = isMultitargetGimmickInSingles = !(!"terastal".equals(this.gimmickID) && !"dynamax".equals(this.gimmickID) || moveTarget != MoveTarget.allAdjacent && moveTarget != MoveTarget.allAdjacentFoes && moveTarget != MoveTarget.adjacentFoe || activeBattlePokemon.getBattle().getFormat().getBattleType() != BattleTypes.INSTANCE.getSINGLES());
        if (this.targetPnx == null) {
            if (activeBattlePokemon.getBattle().getFormat().getBattleType() == BattleTypes.INSTANCE.getSINGLES() && moveTarget == MoveTarget.adjacentFoe) {
                return true;
            }
            return isMultitargetGimmickInSingles;
        }
        Pair targetPokemon = activeBattlePokemon.getActor().getBattle().getActorAndActiveSlotFromPNX(this.targetPnx);
        if (!availableTargets.contains(targetPokemon.getSecond())) {
            return false;
        }
        if (isMultitargetGimmickInSingles) {
            this.targetPnx = null;
            return true;
        }
        return true;
    }
}

