/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.genesisforms.mixin;

import com.cobblemon.mod.common.battles.runner.graal.GraalShowdownUnbundler;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import me.unariginal.genesisforms.GenesisForms;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GraalShowdownUnbundler.class})
public class ShowdownUnbundlerMixin {
    @Unique
    private boolean loaded = false;

    @Inject(method={"attemptUnbundle"}, at={@At(value="TAIL")}, remap=false)
    private void replaceScripts(CallbackInfo info) {
        if (!this.loaded) {
            this.loaded = true;
            Path showdownDirectory = Path.of("./showdown", new String[0]);
            Path simDirectory = Path.of("./showdown/sim", new String[0]);
            Path dataDirectory = Path.of("./showdown/data", new String[0]);
            try {
                Files.createDirectories(simDirectory, new FileAttribute[0]);
                Files.createDirectories(dataDirectory, new FileAttribute[0]);
                this.replaceFile("/showdown_scripts/index.js", showdownDirectory.resolve("index.js"));
                this.replaceFile("/showdown_scripts/battle-action.js", simDirectory.resolve("battle-actions.js"));
                this.replaceFile("/showdown_scripts/conditions.js", dataDirectory.resolve("conditions.js"));
                this.replaceFile("/showdown_scripts/side.js", simDirectory.resolve("side.js"));
                GenesisForms.LOGGER.info("[Genesis] Showdown files loaded!");
            }
            catch (IOException e) {
                GenesisForms.LOGGER.error("[Genesis] Showdown files failed to load!");
            }
        }
    }

    @Unique
    private void replaceFile(String resourcePath, Path targetPath) {
        try (InputStream inputStream = this.getClass().getResourceAsStream(resourcePath);){
            if (inputStream == null) {
                GenesisForms.LOGGER.error("[Genesis] Resource {} not found!", (Object)resourcePath);
                return;
            }
            if (Files.readAllLines(targetPath).stream().anyMatch(line -> line.contains("GenesisForms"))) {
                GenesisForms.LOGGER.info("[Genesis] Resource {} has already been modified, skipping.", (Object)resourcePath);
                return;
            }
            Files.copy(inputStream, targetPath, StandardCopyOption.REPLACE_EXISTING);
            GenesisForms.LOGGER.info("[Genesis] Loaded showdown override file: {}", (Object)targetPath);
        }
        catch (IOException e) {
            GenesisForms.LOGGER.error("[Genesis] Failed to copy showdown override file {}!{}", (Object)resourcePath, (Object)e.getMessage());
        }
    }
}

