/*
 * Decompiled with CFR 0.152.
 */
package me.unariginal.genesisforms.utils;

import com.cobblemon.mod.common.api.moves.BenchedMove;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.properties.CustomPokemonProperty;
import com.cobblemon.mod.common.pokemon.EVs;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.IVs;
import com.cobblemon.mod.common.pokemon.OriginalTrainerType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class PokemonUtils {
    public static boolean playerOwnsPokemon(class_1657 player, Pokemon pokemon) {
        class_3222 ownerPlayer = pokemon.getOwnerPlayer();
        if (ownerPlayer == null) {
            return false;
        }
        return ownerPlayer.method_5667().equals(player.method_5667());
    }

    public static class_2487 saveToNBT(PokemonProperties properties) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("OriginalText", properties.getOriginalString());
        if (properties.getLevel() != null) {
            nbt.method_10569("Level", properties.getLevel().intValue());
        }
        if (properties.getShiny() != null) {
            nbt.method_10556("Shiny", properties.getShiny().booleanValue());
        }
        if (properties.getGender() != null) {
            nbt.method_10582("Gender", properties.getGender().name());
        }
        if (properties.getSpecies() != null) {
            nbt.method_10582("SpeciesText", properties.getSpecies());
        }
        if (properties.getForm() != null) {
            nbt.method_10582("FormId", properties.getForm());
        }
        if (properties.getFriendship() != null) {
            nbt.method_10569("Friendship", properties.getFriendship().intValue());
        }
        if (properties.getPokeball() != null) {
            nbt.method_10582("CaughtBall", properties.getPokeball());
        }
        if (properties.getNature() != null) {
            nbt.method_10582("Nature", properties.getNature());
        }
        if (properties.getAbility() != null) {
            nbt.method_10582("Ability", properties.getAbility());
        }
        if (properties.getStatus() != null) {
            nbt.method_10582("StatusName", properties.getStatus());
        }
        if (properties.getIvs() != null) {
            nbt.method_10566("IVs", (class_2520)IVs.getCODEC().encodeStart((DynamicOps)class_2509.field_11560, (Object)properties.getIvs()).result().get());
        }
        if (properties.getEvs() != null) {
            nbt.method_10566("EVs", (class_2520)EVs.getCODEC().encodeStart((DynamicOps)class_2509.field_11560, (Object)properties.getEvs()).result().get());
        }
        if (properties.getType() != null) {
            nbt.method_10582("ElementalType", properties.getType());
        }
        if (properties.getTeraType() != null) {
            nbt.method_10582("TeraType", properties.getTeraType());
        }
        if (properties.getDmaxLevel() != null) {
            nbt.method_10569("DmaxLevel", properties.getDmaxLevel().intValue());
        }
        if (properties.getGmaxFactor() != null) {
            nbt.method_10556("GmaxFactor", properties.getGmaxFactor().booleanValue());
        }
        if (properties.getTradeable() != null) {
            nbt.method_10556("Tradeable", properties.getTradeable().booleanValue());
        }
        if (properties.getOriginalTrainerType() != null) {
            nbt.method_10569("PokemonOriginalTrainerType", properties.getOriginalTrainerType().ordinal());
        }
        if (properties.getOriginalTrainer() != null) {
            nbt.method_10582("PokemonOriginalTrainer", properties.getOriginalTrainer());
        }
        if (properties.getMoves() != null) {
            String moves = "";
            for (String move : properties.getMoves()) {
                moves = moves.concat(move + ",");
            }
            nbt.method_10582("Moves", moves);
        }
        if (properties.getHeldItem() != null) {
            nbt.method_10582("HeldItem", properties.getHeldItem());
        }
        class_2499 custom = new class_2499();
        for (CustomPokemonProperty pokemonProperty : properties.getCustomProperties()) {
            custom.add((Object)class_2519.method_23256((String)pokemonProperty.asString()));
        }
        nbt.method_10566("CustomProperties", (class_2520)custom);
        return nbt;
    }

    public static PokemonProperties loadFromNBT(class_2487 nbt) {
        PokemonProperties properties = new PokemonProperties();
        properties.setOriginalString(nbt.method_10558("OriginalText"));
        if (nbt.method_10545("Level")) {
            properties.setLevel(Integer.valueOf(nbt.method_10550("Level")));
        }
        if (nbt.method_10545("Shiny")) {
            properties.setShiny(Boolean.valueOf(nbt.method_10577("Shiny")));
        }
        if (nbt.method_10545("Gender")) {
            properties.setGender(Gender.valueOf((String)nbt.method_10558("Gender")));
        }
        if (nbt.method_10545("SpeciesText")) {
            properties.setSpecies(nbt.method_10558("SpeciesText"));
        }
        if (nbt.method_10545("FormId")) {
            properties.setForm(nbt.method_10558("FormId"));
        }
        if (nbt.method_10545("Friendship")) {
            properties.setFriendship(Integer.valueOf(nbt.method_10550("Friendship")));
        }
        if (nbt.method_10545("CaughtBall")) {
            properties.setPokeball(nbt.method_10558("CaughtBall"));
        }
        if (nbt.method_10545("Nature")) {
            properties.setNature(nbt.method_10558("Nature"));
        }
        if (nbt.method_10545("Ability")) {
            properties.setAbility(nbt.method_10558("Ability"));
        }
        if (nbt.method_10545("StatusName")) {
            properties.setStatus(nbt.method_10558("StatusName"));
        }
        if (nbt.method_10545("IVs")) {
            properties.setIvs((IVs)((Pair)IVs.getCODEC().decode((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("IVs")).result().get()).getFirst());
        }
        if (nbt.method_10545("EVs")) {
            properties.setEvs((EVs)((Pair)EVs.getCODEC().decode((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562("EVs")).result().get()).getFirst());
        }
        if (nbt.method_10545("ElementalType")) {
            properties.setType(nbt.method_10558("ElementalType"));
        }
        if (nbt.method_10545("TeraType")) {
            properties.setTeraType(nbt.method_10558("TeraType"));
        }
        if (nbt.method_10545("DmaxLevel")) {
            properties.setDmaxLevel(Integer.valueOf(nbt.method_10550("DmaxLevel")));
        }
        if (nbt.method_10545("GmaxFactor")) {
            properties.setGmaxFactor(Boolean.valueOf(nbt.method_10577("GmaxFactor")));
        }
        if (nbt.method_10545("Tradeable")) {
            properties.setTradeable(Boolean.valueOf(nbt.method_10577("Tradeable")));
        }
        if (nbt.method_10545("PokemonOriginalTrainerType")) {
            properties.setOriginalTrainerType(OriginalTrainerType.valueOf((String)nbt.method_10558("PokemonOriginalTrainerType")));
        }
        if (nbt.method_10545("PokemonOriginalTrainer")) {
            properties.setOriginalTrainer(nbt.method_10558("PokemonOriginalTrainer"));
        }
        if (nbt.method_10545("Moves")) {
            properties.setMoves(Arrays.stream(nbt.method_10558("Moves").split(",")).toList());
        }
        if (nbt.method_10545("HeldItem")) {
            properties.setHeldItem(nbt.method_10558("HeldItem"));
        }
        if (nbt.method_10545("CustomProperties")) {
            class_2499 custom = nbt.method_10554("CustomProperties", 8);
            for (class_2520 element : custom) {
                properties.getCustomProperties().addAll(PokemonProperties.Companion.parse(element.method_10714()).getCustomProperties());
            }
        }
        properties.updateAspects();
        return properties;
    }

    public static void fixRotomMoves(Pokemon pokemon) {
        ArrayList<Move> newMoves = new ArrayList<Move>();
        for (Move move : pokemon.getMoveSet().getMoves()) {
            if (move.getTemplate().getName().equalsIgnoreCase("overheat") || move.getTemplate().getName().equalsIgnoreCase("hydropump") || move.getTemplate().getName().equalsIgnoreCase("blizzard") || move.getTemplate().getName().equalsIgnoreCase("airslash") || move.getTemplate().getName().equalsIgnoreCase("leafstorm")) continue;
            newMoves.add(move);
        }
        for (int i = 0; i < newMoves.size(); ++i) {
            pokemon.getMoveSet().setMove(i, (Move)newMoves.get(i));
        }
        ArrayList<BenchedMove> newBenchedMoves = new ArrayList<BenchedMove>();
        for (BenchedMove move : pokemon.getBenchedMoves()) {
            if (move.getMoveTemplate().getName().equalsIgnoreCase("overheat") || move.getMoveTemplate().getName().equalsIgnoreCase("hydropump") || move.getMoveTemplate().getName().equalsIgnoreCase("blizzard") || move.getMoveTemplate().getName().equalsIgnoreCase("airslash") || move.getMoveTemplate().getName().equalsIgnoreCase("leafstorm")) continue;
            newBenchedMoves.add(move);
        }
        pokemon.getBenchedMoves().clear();
        pokemon.getBenchedMoves().addAll(newBenchedMoves);
    }
}

