/*
 * Decompiled with CFR 0.152.
 */
package loggamja.sync;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import loggamja.sync.TickSyncConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8921;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TickSyncMain
implements ModInitializer {
    public static final String MOD_ID = "tick-sync";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"tick-sync");
    boolean isTickRateChangedLastTick;
    public static boolean isPacketReceivedThisTick;
    long lastSyncTime = System.currentTimeMillis();
    static long lastServerPacketTime;
    public static long avgPacketDelay;
    List<Long> packetDelayBuffer = new ArrayList<Long>();
    float tickRatioConst;
    public static float clientTPS;
    public static float serverTPS;
    public static final int samplingRange = 55;
    public static float[] packetDelayHistogram;
    static TickSyncConfig cfg;

    public void onInitialize() {
        ClientTickEvents.START_CLIENT_TICK.register(client -> this.onClientTickStart());
        ClientTickEvents.END_CLIENT_TICK.register(client -> this.onClientTickEnd());
        TickSyncConfig.INSTANCE.load();
        cfg = TickSyncConfig.INSTANCE;
    }

    public static void onEntityPacket() {
        boolean useLastPacket;
        class_310 client = class_310.method_1551();
        boolean bl = useLastPacket = TickSyncMain.cfg.useLastPacket && client.method_47599() >= 95;
        if (useLastPacket || !isPacketReceivedThisTick) {
            lastServerPacketTime = System.currentTimeMillis();
        }
        isPacketReceivedThisTick = true;
    }

    public void onClientTickStart() {
        this.tickRatioConst = 20.0f / serverTPS;
        if (TickSyncMain.isPlayingInGame()) {
            long now = System.currentTimeMillis();
            long packetDelay = now - lastServerPacketTime;
            if (0L < packetDelay && (float)packetDelay < 55.0f * this.tickRatioConst) {
                this.addToTickDeltaBuffer(packetDelay);
            } else {
                this.addToTickDeltaBuffer(avgPacketDelay);
            }
            if (0L < packetDelay && packetDelay < 55L) {
                int n = (int)packetDelay;
                packetDelayHistogram[n] = packetDelayHistogram[n] + 1.0f;
            }
            avgPacketDelay = (long)this.packetDelayBuffer.stream().mapToLong(Long::longValue).average().orElse(0.0);
        }
        isPacketReceivedThisTick = false;
        int i = 0;
        while (i < 55) {
            int n = i++;
            packetDelayHistogram[n] = packetDelayHistogram[n] * 0.95f;
        }
    }

    public static boolean isPlayingInGame() {
        class_310 client = class_310.method_1551();
        return client.field_1687 != null && client.field_1724 != null && !client.method_1493() && client.method_47599() >= 40;
    }

    void addToTickDeltaBuffer(long newDelta) {
        this.packetDelayBuffer.add(newDelta);
        int tickBufferSize = TickSyncMain.cfg.tickSyncMargin;
        while (this.packetDelayBuffer.size() > tickBufferSize) {
            this.packetDelayBuffer.removeFirst();
        }
    }

    void onClientTickEnd() {
        if (this.isTickRateChangedLastTick) {
            this.isTickRateChangedLastTick = false;
            this.setTickRate(Math.min(serverTPS, 20.0f));
        }
        long now = System.currentTimeMillis();
        if (TickSyncMain.cfg.isTickSyncOn && TickSyncMain.isPlayingInGame() && now - this.lastSyncTime > 1000L) {
            if (this.isWeirdSyncOccurred()) {
                this.fixWeirdSync();
            }
            if (this.isTickSyncRequired()) {
                this.matchTickSync();
            }
        }
    }

    boolean isWeirdSyncOccurred() {
        if (this.packetDelayBuffer.isEmpty()) {
            return false;
        }
        int tickBufferSize = TickSyncMain.cfg.tickSyncMargin;
        float min = Collections.min(this.packetDelayBuffer).longValue();
        float max = Collections.max(this.packetDelayBuffer).longValue();
        return this.packetDelayBuffer.size() >= tickBufferSize && max - min > 35.0f * this.tickRatioConst && serverTPS <= 40.0f;
    }

    void fixWeirdSync() {
        if (this.packetDelayBuffer.isEmpty()) {
            return;
        }
        this.lastSyncTime = System.currentTimeMillis();
        float min = Math.min((long)(TickSyncMain.cfg.tickSyncMargin / 2), Collections.min(this.packetDelayBuffer));
        long tickToPush = TickSyncMain.quantizeToFrame(((float)TickSyncMain.cfg.tickSyncMargin - min) * this.tickRatioConst);
        this.shiftNextTickDuration(tickToPush);
    }

    boolean isTickSyncRequired() {
        return this.getThreshold() < avgPacketDelay && serverTPS <= 40.0f;
    }

    long getThreshold() {
        long threshold = (long)((float)TickSyncMain.cfg.tickSyncMargin * this.tickRatioConst) + 4L;
        class_310 client = class_310.method_1551();
        float frameDuration = 1000.0f / (float)client.method_47599();
        if ((float)threshold < frameDuration) {
            return (long)(frameDuration * 1.5f);
        }
        return threshold;
    }

    void matchTickSync() {
        this.lastSyncTime = System.currentTimeMillis();
        int tickDuration = (int)(1000.0f / serverTPS);
        long tickToPush = (long)tickDuration - avgPacketDelay + TickSyncMain.quantizeToFrame((float)TickSyncMain.cfg.tickSyncMargin * this.tickRatioConst);
        if (tickToPush > (long)(tickDuration / 2)) {
            tickToPush -= (long)tickDuration;
        }
        this.shiftNextTickDuration(tickToPush);
    }

    public static long quantizeToFrame(float margin) {
        class_310 client = class_310.method_1551();
        float frameDuration = 1000.0f / (float)client.method_47599();
        if (margin < frameDuration) {
            return (long)frameDuration;
        }
        return (long)((float)Math.round(margin / frameDuration) * frameDuration);
    }

    void shiftNextTickDuration(long term) {
        long tickDuration = (long)(1000.0f / serverTPS);
        float tickRate = 1000.0f / (float)(term + tickDuration);
        this.setTickRate(tickRate);
        this.packetDelayBuffer.clear();
        this.addToTickDeltaBuffer(TickSyncMain.cfg.tickSyncMargin);
        avgPacketDelay = TickSyncMain.cfg.tickSyncMargin;
        this.isTickRateChangedLastTick = true;
    }

    void setTickRate(float tickRate) {
        clientTPS = tickRate;
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world != null) {
            class_8921 tickManager = world.method_54719();
            tickManager.method_54671(tickRate);
        }
    }

    public static boolean isMinecraftAtLeast(String versionString) {
        Optional<ModMetadata> mcMeta = FabricLoader.getInstance().getModContainer("minecraft").map(container -> container.getMetadata());
        if (mcMeta.isEmpty()) {
            return false;
        }
        Version current = mcMeta.get().getVersion();
        try {
            Version target = Version.parse((String)versionString);
            return current.compareTo((Object)target) >= 0;
        }
        catch (VersionParsingException e) {
            return false;
        }
    }

    static {
        clientTPS = 20.0f;
        serverTPS = 20.0f;
        packetDelayHistogram = new float[55];
    }
}

