/*
 * Decompiled with CFR 0.152.
 */
package host.plas.stonedamager.events;

import host.plas.stonedamager.StoneDamager;
import host.plas.stonedamager.data.DamagableSelection;
import host.plas.stonedamager.events.StoneDamagerEvent;
import host.plas.stonedamager.objects.DistanceComparator;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class ScheduledDamageEvent
extends StoneDamagerEvent {
    private LivingEntity entity;
    private DamagableSelection damagableSelection;

    public ScheduledDamageEvent(LivingEntity entity, DamagableSelection damagableSelection) {
        this.entity = entity;
        this.damagableSelection = damagableSelection;
    }

    public Optional<Player> getClosestPlayer() {
        boolean tryFind = StoneDamager.getMainConfig().isTryFindPlayer();
        if (!tryFind) {
            return Optional.empty();
        }
        double radius = StoneDamager.getMainConfig().getFindPlayerRadius();
        return this.entity.getNearbyEntities(radius, radius, radius).stream().filter(e -> e instanceof Player).map(e -> (Player)e).min(new DistanceComparator(this.getEntityLocation()));
    }

    public Location getEntityLocation() {
        return this.entity.getLocation();
    }

    public void damageEntity(double damage) {
        this.getClosestPlayer().ifPresentOrElse(p -> this.getEntity().damage(damage, (Entity)p), () -> this.getEntity().damage(damage));
    }

    public void damageEntity() {
        this.damageEntity(this.getDamagableSelection().getDamageAmount());
    }

    public void setEntity(LivingEntity entity) {
        this.entity = entity;
    }

    public void setDamagableSelection(DamagableSelection damagableSelection) {
        this.damagableSelection = damagableSelection;
    }

    public LivingEntity getEntity() {
        return this.entity;
    }

    public DamagableSelection getDamagableSelection() {
        return this.damagableSelection;
    }
}

