/*
 * Decompiled with CFR 0.152.
 */
package host.plas.stonedamager.utils;

import host.plas.bou.scheduling.TaskManager;
import host.plas.bou.utils.ClassHelper;
import host.plas.bou.utils.EntityUtils;
import host.plas.stonedamager.StoneDamager;
import host.plas.stonedamager.data.DamagableSelection;
import host.plas.stonedamager.events.ScheduledDamageEvent;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class DamageHandler {
    private static ConcurrentSkipListMap<DamagableSelection, Long> tickMap = new ConcurrentSkipListMap();

    public static void setTickable(DamagableSelection damagableSelection) {
        tickMap.put(damagableSelection, damagableSelection.getTicksPerDamage());
    }

    public static void unsetTickable(String identifier) {
        tickMap.forEach((damagableSelection, aLong) -> {
            if (damagableSelection.getIdentifier().equals(identifier)) {
                tickMap.remove(damagableSelection);
            }
        });
    }

    public static void addAllTickables(ConcurrentSkipListSet<DamagableSelection> tickMap) {
        tickMap.forEach(DamageHandler::setTickable);
    }

    public static void clearTickables() {
        tickMap.clear();
    }

    public static Optional<DamagableSelection> getTickable(String identifier) {
        return tickMap.keySet().stream().filter(d -> d.getIdentifier().equals(identifier)).findFirst();
    }

    public static long getTicksLeft(String identifier) {
        return DamageHandler.getTickable(identifier).map(d -> tickMap.get(d)).orElse(1L);
    }

    public static void tickTicksLeft(String identifier) {
        DamageHandler.getTickable(identifier).ifPresent(d -> {
            long ticks = tickMap.get(d);
            tickMap.put((DamagableSelection)d, --ticks);
        });
    }

    public static void resetTicksLeft(String identifier) {
        DamageHandler.getTickable(identifier).ifPresent(d -> tickMap.put((DamagableSelection)d, d.getTicksPerDamage()));
    }

    public static void fire(LivingEntity entity, DamagableSelection damagableSelection, boolean isInSync) {
        ScheduledDamageEvent event = (ScheduledDamageEvent)new ScheduledDamageEvent(entity, damagableSelection).fire();
        if (event.isCancelled()) {
            return;
        }
        try {
            if (isInSync) {
                DamageHandler.fireInSync(event);
            } else if (ClassHelper.isFolia()) {
                TaskManager.getScheduler().runTask((Entity)entity, () -> DamageHandler.fireInSync(event));
            } else {
                TaskManager.getScheduler().runTask(() -> DamageHandler.fireInSync(event));
            }
        }
        catch (Throwable e) {
            StoneDamager.getInstance().logWarningWithInfo("Error while firing damage event.", e);
        }
    }

    private static Player getNearestPlayer(LivingEntity entity, double range) {
        Player nearest = null;
        double nearestDist = Double.MAX_VALUE;
        for (Player p : entity.getWorld().getPlayers()) {
            double dist;
            if (!p.isOnline() || p.isDead() || !((dist = p.getLocation().distance(entity.getLocation())) <= range) || !(dist < nearestDist)) continue;
            nearestDist = dist;
            nearest = p;
        }
        return nearest;
    }

    public static void fireInSync(ScheduledDamageEvent event) {
        try {
            event.damageEntity();
        }
        catch (Throwable e) {
            StoneDamager.getInstance().logWarningWithInfo("Error while firing damage event in sync.", e);
        }
    }

    public static void tick() {
        try {
            DamageHandler.getTickMap().forEach((damagableSelection, ticks) -> {
                if (!damagableSelection.isEnabled()) {
                    return;
                }
                if (ticks > 0L) {
                    DamageHandler.tickTicksLeft(damagableSelection.getIdentifier());
                } else {
                    EntityUtils.collectEntitiesThenDo(entity -> {
                        try {
                            if (ClassHelper.isFolia()) {
                                TaskManager.getScheduler().runTask(entity, DamageHandler.getDamageTask(damagableSelection, entity));
                            } else {
                                TaskManager.getScheduler().runTask(DamageHandler.getDamageTask(damagableSelection, entity));
                            }
                        }
                        catch (Throwable e) {
                            StoneDamager.getInstance().logWarningWithInfo("Error while ticking entities.", e);
                        }
                    });
                    DamageHandler.resetTicksLeft(damagableSelection.getIdentifier());
                }
            });
        }
        catch (Throwable e) {
            StoneDamager.getInstance().logWarningWithInfo("Error while ticking entities.", e);
        }
    }

    public static Runnable getDamageTask(DamagableSelection damagableSelection, Entity entity) {
        return () -> {
            if (!damagableSelection.isEnabled()) {
                return;
            }
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            if (damagableSelection.check((Entity)livingEntity)) {
                DamageHandler.fire(livingEntity, damagableSelection, true);
            }
        };
    }

    public static ConcurrentSkipListMap<DamagableSelection, Long> getTickMap() {
        return tickMap;
    }

    public static void setTickMap(ConcurrentSkipListMap<DamagableSelection, Long> tickMap) {
        DamageHandler.tickMap = tickMap;
    }
}

