/*
 * Decompiled with CFR 0.152.
 */
package host.plas.stonedamager.config;

import gg.drak.thebase.lib.leonhard.storage.Config;
import gg.drak.thebase.objects.handling.derived.IModifierEventable;
import gg.drak.thebase.storage.resources.flat.simple.SimpleConfiguration;
import host.plas.bou.configs.bits.ConfigurableWhitelist;
import host.plas.stonedamager.StoneDamager;
import host.plas.stonedamager.data.DamagableSelection;
import host.plas.stonedamager.utils.DamageHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListSet;

public class DamagerConfig
extends SimpleConfiguration {
    public DamagerConfig() {
        super("config.yml", (IModifierEventable)StoneDamager.getInstance(), true);
    }

    public void init() {
        this.onReload();
    }

    public void onReload() {
        DamageHandler.clearTickables();
        DamageHandler.addAllTickables(this.getSelections());
        StoneDamager.getInstance().logInfo("&fLoaded &a" + this.getSelections().size() + " &fdamager selections.");
        this.isStoneCutterPatchEnabled();
        String configVersion = this.getConfigVersion();
        if (!configVersion.equals("1.0")) {
            this.delete();
            this.reloadResource(true);
        }
    }

    public ConcurrentSkipListSet<DamagableSelection> getSelections() {
        this.reloadResource();
        ConcurrentSkipListSet<DamagableSelection> selections = new ConcurrentSkipListSet<DamagableSelection>();
        this.singleLayerKeySet("damagers").forEach(key -> {
            String path = "damagers." + key;
            DamagableSelection selection = new DamagableSelection((String)key);
            boolean enabled = (Boolean)this.getOrSetDefault(path + ".enabled", true);
            long ticksPerDamage = (Long)this.getOrSetDefault(path + ".ticks-per-damage", 10L);
            double damageAmount = (Double)this.getOrSetDefault(path + ".damage-amount", 3.0);
            String includePermission = (String)this.getOrSetDefault(path + ".permission.include", "");
            String excludePermission = (String)this.getOrSetDefault(path + ".permission.exclude", "stonedamager.bypass");
            double xOffset = (Double)this.getOrSetDefault(path + ".offset.x", 0.0);
            double yOffset = (Double)this.getOrSetDefault(path + ".offset.y", -0.1);
            double zOffset = (Double)this.getOrSetDefault(path + ".offset.z", 0.0);
            selection.setEnabled(enabled);
            selection.setTicksPerDamage(ticksPerDamage);
            selection.setDamageAmount(damageAmount);
            selection.setIncludePermission(includePermission);
            selection.setExcludePermission(excludePermission);
            selection.setXOffset(xOffset);
            selection.setYOffset(yOffset);
            selection.setZOffset(zOffset);
            List<String> whitelistGroups = List.of("materials", "worlds", "entities");
            whitelistGroups.forEach(group -> {
                ConfigurableWhitelist whitelist = new ConfigurableWhitelist(group);
                List whitelistItems = (List)this.getOrSetDefault(path + "." + group + ".list", new ArrayList());
                boolean blacklist = (Boolean)this.getOrSetDefault(path + "." + group + ".is-blacklist", false);
                whitelist.setBlacklist(blacklist);
                whitelistItems.forEach(arg_0 -> ((ConfigurableWhitelist)whitelist).add(arg_0));
                switch (group) {
                    case "materials": {
                        selection.setMaterials((ConfigurableWhitelist<String>)whitelist);
                        return;
                    }
                    case "worlds": {
                        selection.setWorlds((ConfigurableWhitelist<String>)whitelist);
                        return;
                    }
                    case "entities": {
                        selection.setEntities((ConfigurableWhitelist<String>)whitelist);
                        return;
                    }
                }
            });
            selections.add(selection);
        });
        return selections;
    }

    public String getConfigVersion() {
        this.reloadResource();
        return (String)((Config)this.getResource()).getOrDefault("config-version", (Object)"null");
    }

    public boolean isStoneCutterPatchEnabled() {
        this.reloadResource();
        return (Boolean)this.getOrSetDefault("stonecutter-patch", true);
    }
}

