/*
 * Decompiled with CFR 0.152.
 */
package host.plas.stonedamager.data;

import gg.drak.thebase.objects.Identifiable;
import host.plas.bou.configs.bits.ConfigurableWhitelist;
import host.plas.stonedamager.patch.StoneCutterPatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class DamagableSelection
implements Identifiable {
    private String identifier;
    private ConfigurableWhitelist<String> materials;
    private ConfigurableWhitelist<String> entities;
    private ConfigurableWhitelist<String> worlds;
    private String includePermission;
    private String excludePermission;
    private long ticksPerDamage;
    private double damageAmount;
    private double xOffset;
    private double yOffset;
    private double zOffset;
    private boolean enabled;

    public DamagableSelection(String identifier) {
        this.identifier = identifier;
    }

    public boolean isMaterialsContainsSC() {
        AtomicBoolean contains = new AtomicBoolean(false);
        this.materials.getWhitelist().forEach(material -> {
            if (material.toLowerCase().contains("cutter")) {
                contains.set(true);
            }
        });
        return contains.get();
    }

    public boolean checkMaterial(String material) {
        return this.materials.check((Comparable)((Object)material));
    }

    public boolean checkMaterial(Block block) {
        if (this.isMaterialsContainsSC() && StoneCutterPatch.isStoneCutter(block)) {
            return !this.materials.isBlacklist();
        }
        return this.checkMaterial(block.getType().name());
    }

    public boolean checkWorld(String world) {
        return this.worlds.check((Comparable)((Object)world));
    }

    public boolean checkEntity(String entity) {
        return this.entities.check((Comparable)((Object)entity));
    }

    public boolean checkPermissions(Entity player) {
        if (!(player instanceof Player)) {
            return true;
        }
        if (this.includePermission.isBlank() || this.includePermission.isEmpty()) {
            if (this.excludePermission.isBlank() || this.excludePermission.isEmpty()) {
                return true;
            }
            return !player.hasPermission(this.excludePermission);
        }
        if (this.excludePermission.isBlank() || this.excludePermission.isEmpty()) {
            return player.hasPermission(this.includePermission);
        }
        return player.hasPermission(this.includePermission) && !player.hasPermission(this.excludePermission);
    }

    public boolean checkAll(Entity entity, Block block) {
        return this.checkEntity(entity.getType().name()) && this.checkWorld(block.getWorld().getName()) && this.checkMaterial(block) && this.checkPermissions(entity);
    }

    public boolean check(Entity entity) {
        if (!this.enabled) {
            return false;
        }
        Location location = entity.getLocation().clone();
        Block block = location.add(this.xOffset, this.yOffset, this.zOffset).getBlock();
        return this.checkAll(entity, block);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ConfigurableWhitelist<String> getMaterials() {
        return this.materials;
    }

    public ConfigurableWhitelist<String> getEntities() {
        return this.entities;
    }

    public ConfigurableWhitelist<String> getWorlds() {
        return this.worlds;
    }

    public String getIncludePermission() {
        return this.includePermission;
    }

    public String getExcludePermission() {
        return this.excludePermission;
    }

    public long getTicksPerDamage() {
        return this.ticksPerDamage;
    }

    public double getDamageAmount() {
        return this.damageAmount;
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public double getZOffset() {
        return this.zOffset;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setMaterials(ConfigurableWhitelist<String> materials) {
        this.materials = materials;
    }

    public void setEntities(ConfigurableWhitelist<String> entities) {
        this.entities = entities;
    }

    public void setWorlds(ConfigurableWhitelist<String> worlds) {
        this.worlds = worlds;
    }

    public void setIncludePermission(String includePermission) {
        this.includePermission = includePermission;
    }

    public void setExcludePermission(String excludePermission) {
        this.excludePermission = excludePermission;
    }

    public void setTicksPerDamage(long ticksPerDamage) {
        this.ticksPerDamage = ticksPerDamage;
    }

    public void setDamageAmount(double damageAmount) {
        this.damageAmount = damageAmount;
    }

    public void setXOffset(double xOffset) {
        this.xOffset = xOffset;
    }

    public void setYOffset(double yOffset) {
        this.yOffset = yOffset;
    }

    public void setZOffset(double zOffset) {
        this.zOffset = zOffset;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

