/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.common.metatileentities.multi;

import com.github.gtexpert.core.api.gui.GTEGuiTextures;
import com.github.gtexpert.core.common.GTEConfigHolder;
import gregicality.multiblocks.api.capability.impl.GCYMMultiblockRecipeLogic;
import gregicality.multiblocks.api.metatileentity.GCYMRecipeMapMultiblockController;
import gregtech.api.block.IHeatingCoilBlockStats;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityLargeCrackingUnit
extends GCYMRecipeMapMultiblockController {
    private int coilTier;

    public MetaTileEntityLargeCrackingUnit(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMaps.CRACKING_RECIPES);
        this.recipeMapWorkable = new LargeCrackingUnitWorkableHandler((RecipeMapMultiblockController)this);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityLargeCrackingUnit(this.metaTileEntityId);
    }

    @NotNull
    protected BlockPattern createStructurePattern() {
        TraceabilityPredicate casing = MetaTileEntityLargeCrackingUnit.states((IBlockState[])new IBlockState[]{this.getCasingState()}).setMinGlobalLimited(10);
        TraceabilityPredicate abilities = this.autoAbilities(true, true, true, true, true, true, GTEConfigHolder.gteFlag.featureFlag);
        if (GTEConfigHolder.gteFlag.featureFlag) {
            return FactoryBlockPattern.start().aisle(new String[]{" XXX ", " XXX ", "  X  ", "  X  ", "  X  ", " XXX ", "     "}).aisle(new String[]{"XXXXX", "XXXXX", " CCC ", " CCC ", " CCC ", "XXXXX", " XXX "}).aisle(new String[]{"XXTXX", "XXXXX", "XC#CX", "XC#CX", "XC#CX", "XXXXX", " XHX "}).aisle(new String[]{"XXXXX", "XXXXX", " CCC ", " CCC ", " CCC ", "XXXXX", " XXX "}).aisle(new String[]{" XSX ", " XXX ", "  X  ", "  X  ", "  X  ", " XXX ", "     "}).where('S', this.selfPredicate()).where('X', casing.setMinGlobalLimited(10).or(abilities)).where('T', MetaTileEntityLargeCrackingUnit.tieredCasing().or(casing)).where('H', MetaTileEntityLargeCrackingUnit.abilities((MultiblockAbility[])new MultiblockAbility[]{MultiblockAbility.MUFFLER_HATCH})).where('C', MetaTileEntityLargeCrackingUnit.heatingCoils()).where('#', MetaTileEntityLargeCrackingUnit.air()).where(' ', MetaTileEntityLargeCrackingUnit.any()).build();
        }
        return FactoryBlockPattern.start().aisle(new String[]{"XCCXCCX", "XCCXCCX", "XCCXCCX"}).aisle(new String[]{"XCCXCCX", "X##T##X", "XCCXCCX"}).aisle(new String[]{"XCCXCCX", "XCCSCCX", "XCCXCCX"}).where('S', this.selfPredicate()).where('X', casing.or(abilities)).where('T', casing.or(MetaTileEntityLargeCrackingUnit.tieredCasing())).where('C', MetaTileEntityLargeCrackingUnit.heatingCoils().setMinGlobalLimited(32).setMaxGlobalLimited(32)).where('#', MetaTileEntityLargeCrackingUnit.air()).build();
    }

    public boolean isTiered() {
        return true;
    }

    public boolean isParallel() {
        return true;
    }

    public boolean hasMufflerMechanics() {
        return GTEConfigHolder.gteFlag.featureFlag;
    }

    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.CLEAN_STAINLESS_STEEL_CASING;
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STAINLESS_CLEAN);
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, (boolean)this.isStructureFormed()).setWorkingStatus(this.recipeMapWorkable.isWorkingEnabled(), this.recipeMapWorkable.isActive()).addEnergyUsageLine(this.getEnergyContainer()).addEnergyTierLine((int)GTUtility.getTierByVoltage((long)this.recipeMapWorkable.getMaxVoltage())).addCustom(tl -> {
            if (this.isStructureFormed()) {
                TextComponentString energyDiscount = TextComponentUtil.stringWithColor((TextFormatting)TextFormatting.AQUA, (String)(100 - 10 * this.coilTier + "%"));
                TextComponentTranslation base = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.cracking_unit.energy", (Object[])new Object[]{energyDiscount});
                TextComponentTranslation hover = TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.cracking_unit.energy_hover", (Object[])new Object[0]);
                tl.add(TextComponentUtil.setHover((ITextComponent)base, (ITextComponent[])new ITextComponent[]{hover}));
            }
        }).addParallelsLine(this.recipeMapWorkable.getParallelLimit()).addWorkingStatusLine().addProgressLine(this.recipeMapWorkable.getProgressPercent());
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.format((String)"gtexpert.machine.large_cracking_unit.tooltip.1", (Object[])new Object[0]));
    }

    @NotNull
    protected TextureArea getLogo() {
        return GTEGuiTextures.GTE_LOGO_DARK;
    }

    @NotNull
    protected TextureArea getWarningLogo() {
        return GTEGuiTextures.GTE_LOGO_BLINKING_YELLOW;
    }

    @NotNull
    protected TextureArea getErrorLogo() {
        return GTEGuiTextures.GTE_LOGO_BLINKING_RED;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.CRACKING_UNIT_OVERLAY;
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        Object type = context.get("CoilType");
        this.coilTier = type instanceof IHeatingCoilBlockStats ? ((IHeatingCoilBlockStats)type).getTier() : 0;
    }

    public void invalidateStructure() {
        super.invalidateStructure();
        this.coilTier = -1;
    }

    protected int getCoilTier() {
        return this.coilTier;
    }

    private class LargeCrackingUnitWorkableHandler
    extends GCYMMultiblockRecipeLogic {
        public LargeCrackingUnitWorkableHandler(RecipeMapMultiblockController metaTileEntity) {
            super(metaTileEntity);
        }

        protected void performNonOverclockBonuses(int[] resultOverclock) {
            int coilTier = ((MetaTileEntityLargeCrackingUnit)this.metaTileEntity).getCoilTier();
            if (coilTier > 0) {
                resultOverclock[0] = (int)((double)resultOverclock[0] * (1.0 - (double)coilTier * 0.1));
                resultOverclock[0] = Math.max(1, resultOverclock[0]);
            }
        }
    }
}

