/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.core;

import com.github.gtexpert.core.api.util.GTELog;
import java.util.Iterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class NAE2PatchTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if ("co.neeve.nae2.mixin.upgrades.gregcircuit.MixinDualityInterface".equals(transformedName)) {
            return this.patchMixinDualityInterface(basicClass);
        }
        return basicClass;
    }

    private byte[] patchMixinDualityInterface(byte[] classBytes) {
        try {
            GTELog.logger.info("Patching NAE2 MixinDualityInterface to remove craftingList field");
            ClassReader classReader = new ClassReader(classBytes);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            Iterator fieldIterator = classNode.fields.iterator();
            boolean fieldRemoved = false;
            block2: while (fieldIterator.hasNext()) {
                FieldNode field = (FieldNode)fieldIterator.next();
                if (!"craftingList".equals(field.name) || field.visibleAnnotations == null) continue;
                for (AnnotationNode annotation : field.visibleAnnotations) {
                    if (!"Lorg/spongepowered/asm/mixin/Shadow;".equals(annotation.desc)) continue;
                    GTELog.logger.info("Removing @Shadow craftingList field from NAE2 MixinDualityInterface");
                    fieldIterator.remove();
                    fieldRemoved = true;
                    continue block2;
                }
            }
            if (fieldRemoved) {
                ClassWriter classWriter = new ClassWriter(1);
                classNode.accept((ClassVisitor)classWriter);
                GTELog.logger.info("Successfully patched NAE2 MixinDualityInterface");
                return classWriter.toByteArray();
            }
            GTELog.logger.info("craftingList field not found or already removed in MixinDualityInterface");
        }
        catch (Exception e) {
            GTELog.logger.error("Failed to patch NAE2 MixinDualityInterface: " + e.getMessage(), (Throwable)e);
        }
        return classBytes;
    }
}

