/*
 * Decompiled with CFR 0.152.
 */
package com.github.gtexpert.core.integration.deda.recipemaps.upgrade;

import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.itemupgrade.FusionUpgradeRecipe;
import com.brandon3055.draconicevolution.api.itemupgrade.IUpgradableItem;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.items.ToolUpgrade;
import com.github.gtexpert.core.api.util.GTELog;
import com.github.gtexpert.core.integration.deda.recipemaps.upgrade.UpgradeRecipeProperty;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.chance.output.ChancedOutputList;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.ingredients.nbtmatch.NBTCondition;
import gregtech.api.recipes.ingredients.nbtmatch.NBTMatcher;
import gregtech.api.recipes.ingredients.nbtmatch.NBTTagType;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.ValidationResult;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeRecipeBuilder
extends RecipeBuilder<UpgradeRecipeBuilder> {
    private ItemStack catalyst;
    private String upgradeName;
    private int currentLevel = -1;

    public UpgradeRecipeBuilder() {
    }

    public UpgradeRecipeBuilder(UpgradeRecipeBuilder recipeBuilder) {
        super((RecipeBuilder)recipeBuilder);
        this.catalyst = recipeBuilder.catalyst;
        this.upgradeName = recipeBuilder.upgradeName;
        this.currentLevel = recipeBuilder.currentLevel;
    }

    public UpgradeRecipeBuilder copy() {
        return new UpgradeRecipeBuilder(this);
    }

    public boolean applyProperty(@NotNull String key, @Nullable Object value) {
        if (!key.equals("draconic_fusion_upgrade")) {
            return super.applyProperty(key, value);
        }
        if (!(value instanceof FusionUpgradeRecipe)) {
            GTELog.logger.error("Property for draconic upgrade must be an instance of FusionUpgradeRecipe!", new Throwable());
        }
        this.applyProperty(UpgradeRecipeProperty.getInstance(), value);
        return true;
    }

    protected EnumValidationResult validate() {
        super.validate();
        if (this.upgradeName == null) {
            GTELog.logger.error("Upgrade name has not been set", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (this.currentLevel < 0) {
            GTELog.logger.error("Level has not been set", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        if (this.recipeStatus == EnumValidationResult.INVALID) {
            return this.recipeStatus;
        }
        if (this.catalyst == null) {
            GTELog.logger.error("Catalyst has not been set", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
        } else if (!(this.catalyst.getItem() instanceof IUpgradableItem)) {
            GTELog.logger.error("Catalyst is not an instance of IUpgradableItem", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
        } else if (!((IUpgradableItem)this.catalyst.getItem()).getValidUpgrades(this.catalyst).contains(this.upgradeName)) {
            GTELog.logger.error("Upgrade " + this.upgradeName + " is not valid for this catalyst", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
        } else if (((IUpgradableItem)this.catalyst.getItem()).getMaxUpgradeLevel(this.catalyst, this.upgradeName) < this.currentLevel + 1) {
            GTELog.logger.error("Max level of upgrade " + this.upgradeName + " is " + ((IUpgradableItem)this.catalyst.getItem()).getMaxUpgradeLevel(this.catalyst, this.upgradeName) + ", which supplied level is going to exceed", new Throwable());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        return this.recipeStatus;
    }

    public ValidationResult<Recipe> build() {
        EnumValidationResult validationResult = this.finalizeAndValidate();
        if (validationResult != EnumValidationResult.INVALID) {
            this.setFusionProperties();
        }
        return ValidationResult.newResult((EnumValidationResult)validationResult, (Object)new Recipe(this.inputs, this.outputs, new ChancedOutputList(this.chancedOutputLogic, this.chancedOutputs), this.fluidInputs, this.fluidOutputs, new ChancedOutputList(this.chancedFluidOutputLogic, this.chancedFluidOutputs), this.duration, this.EUt, this.hidden, this.isCTRecipe, this.recipePropertyStorage, this.category));
    }

    private void setFusionProperties() {
        int upgradeLevel = this.currentLevel + 1;
        ItemStack input = this.catalyst.copy();
        ItemStack output = this.catalyst.copy();
        UpgradeHelper.setUpgradeLevel((ItemStack)input, (String)this.upgradeName, (int)this.currentLevel);
        UpgradeHelper.setUpgradeLevel((ItemStack)output, (String)this.upgradeName, (int)upgradeLevel);
        this.inputs.add(0, new GTRecipeItemInput(input).setNBTMatchingCondition(NBTMatcher.RECURSIVE_EQUAL_TO, NBTCondition.create((NBTTagType)NBTTagType.COMPOUND, (String)"DEUpgrades", (Object)NBTCondition.create((NBTTagType)NBTTagType.BYTE, (String)this.upgradeName, (Object)((byte)this.currentLevel)))));
        this.outputs.add(output);
        ItemStack upgradeKey = new ItemStack((Item)DEFeatures.toolUpgrade, 1, ((Integer)ToolUpgrade.NAME_TO_ID.get(this.upgradeName)).intValue());
        this.setFusionRecipe(new FusionUpgradeRecipe(this.upgradeName, upgradeKey, 0L, this.currentLevel, upgradeLevel, new Object[]{input}));
        this.inputs.add(1, new GTRecipeItemInput(upgradeKey, upgradeKey.getCount()).setNonConsumable());
    }

    public UpgradeRecipeBuilder catalyst(ItemStack catalyst) {
        this.catalyst = catalyst;
        return this;
    }

    public UpgradeRecipeBuilder upgradeName(String upgradeName) {
        this.upgradeName = upgradeName;
        return this;
    }

    public UpgradeRecipeBuilder level(int level) {
        this.currentLevel = level;
        return this;
    }

    public void setFusionRecipe(FusionUpgradeRecipe fusionRecipe) {
        this.applyProperty(UpgradeRecipeProperty.getInstance(), fusionRecipe);
    }

    public ItemStack getCatalyst() {
        return this.catalyst;
    }

    public String getUpgradeName() {
        return this.upgradeName;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public FusionUpgradeRecipe getFusionRecipe() {
        return this.recipePropertyStorage == null ? null : (FusionUpgradeRecipe)this.recipePropertyStorage.getRecipePropertyValue((RecipeProperty)UpgradeRecipeProperty.getInstance(), null);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(UpgradeRecipeProperty.getInstance().getKey(), (Object)this.getFusionRecipe()).toString();
    }
}

